/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.shared.components.CollapsablePanel;

public class CollapsablePanelHeader
extends FlowPanel
implements HasText,
OpenHandler<CollapsablePanel>,
CloseHandler<CollapsablePanel> {
    private final Label textLabel;
    private final Image iconImage;
    private final CollapsablePanel.Imager imager;
    private final CollapsablePanel collapsablePanel;
    private final boolean hasToolbar;
    private final SimplePanel toolbarPanel;
    private final ClickableHeader clickableHeaderPanel;
    private static final String STYLENAME_TOOLBAR = "collapsablePanel-toolbar";
    private static final String STYLENAME_HEADER_COLLAPSE_AREA = "collapsablePanel-header-collapse";
    private static final String STYLENAME_HEADER_TEXT = "collapsablePanel-header-text";
    private static final String STYLENAME_HEADER_IMAGE = "collapsablePanel-header-image";

    protected CollapsablePanelHeader(CollapsablePanel collapsablePanel, CollapsablePanel.Imager imager, String text, boolean hasToolbar) {
        this.imager = imager;
        this.hasToolbar = hasToolbar;
        this.collapsablePanel = collapsablePanel;
        this.iconImage = imager.makeImage();
        this.iconImage.addStyleName(STYLENAME_HEADER_IMAGE);
        this.textLabel = new Label(text);
        this.textLabel.addStyleName(STYLENAME_HEADER_TEXT);
        this.clickableHeaderPanel = new ClickableHeader(collapsablePanel);
        this.clickableHeaderPanel.setStyleName(STYLENAME_HEADER_COLLAPSE_AREA);
        this.add((Widget)this.clickableHeaderPanel);
        FlowPanel clickableInnerPanel = new FlowPanel();
        this.clickableHeaderPanel.setWidget((Widget)clickableInnerPanel);
        clickableInnerPanel.add((Widget)this.iconImage);
        clickableInnerPanel.add((Widget)this.textLabel);
        if (hasToolbar) {
            this.toolbarPanel = new SimplePanel();
            this.add((Widget)this.toolbarPanel);
        } else {
            this.toolbarPanel = null;
        }
        collapsablePanel.addOpenHandler(this);
        collapsablePanel.addCloseHandler(this);
        this.setStyle();
    }

    protected CollapsablePanelHeader(CollapsablePanel collapsablePanel, final ImageResource openImage, final ImageResource closedImage, String text, boolean hasToolbar) {
        this(collapsablePanel, new CollapsablePanel.Imager(){

            @Override
            public Image makeImage() {
                return new Image(closedImage);
            }

            @Override
            public void updateImage(boolean open, Image image) {
                if (open) {
                    image.setResource(openImage);
                } else {
                    image.setResource(closedImage);
                }
            }
        }, text, hasToolbar);
    }

    public void setToolbar(Widget toolbar) {
        if (this.hasToolbar && this.toolbarPanel != null) {
            this.toolbarPanel.setWidget(toolbar);
            this.toolbarPanel.setStyleName(STYLENAME_TOOLBAR);
        }
    }

    protected void setCollapsingEnabled(boolean enabled) {
        this.clickableHeaderPanel.setClickable(enabled);
    }

    public final String getText() {
        return this.textLabel.getText();
    }

    public final void onClose(CloseEvent<CollapsablePanel> event) {
        this.setStyle();
    }

    public final void onOpen(OpenEvent<CollapsablePanel> event) {
        this.setStyle();
    }

    public final void setText(String text) {
        this.textLabel.setText(text);
    }

    private void setStyle() {
        this.imager.updateImage(this.collapsablePanel.isOpen(), this.iconImage);
    }

    private final class ClickableHeader
    extends SimplePanel {
        private final CollapsablePanel panel;
        private boolean isClickable;

        private ClickableHeader(CollapsablePanel panel) {
            super((com.google.gwt.dom.client.Element)DOM.createAnchor());
            this.isClickable = true;
            this.panel = panel;
            Element elem = this.getElement();
            elem.setPropertyString("href", "javascript:void(0);");
            this.sinkEvents(1);
        }

        protected void setClickable(boolean enabled) {
            this.isClickable = enabled;
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 1: {
                    event.preventDefault();
                    if (!this.isClickable) break;
                    this.panel.setOpen(!this.panel.isOpen());
                }
            }
        }
    }
}

