/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.ExpandedListEditorUi;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUi;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.List;

public abstract class CollapsedListEditorUi<ValueType>
extends ListEditorUi<ValueType> {
    private static final int collapsedTitleMaxLength = 20;
    private final String popupDialogTitle;
    private final ExpandedListEditorUi<ValueType> expandedUi;
    private TextBox collapsedValuesBox;
    private Button collapsedEditButton;

    public CollapsedListEditorUi(StringMessages stringMessages, String popupDialogTitle, ExpandedListEditorUi<ValueType> expandedUi) {
        super(stringMessages);
        this.popupDialogTitle = popupDialogTitle;
        this.expandedUi = expandedUi;
    }

    protected abstract String getCollapsedValueText(Iterable<ValueType> var1);

    protected abstract ListEditorComposite<ValueType> createExpandedUi(Iterable<ValueType> var1, ExpandedListEditorUi<ValueType> var2);

    @Override
    public void setContext(ListEditorComposite<ValueType> context) {
        super.setContext(context);
    }

    @Override
    public Widget initWidget() {
        HorizontalPanel panel = new HorizontalPanel();
        this.collapsedValuesBox = new TextBox();
        this.collapsedValuesBox.setReadOnly(true);
        this.collapsedEditButton = new Button(this.getStringMessages().edit());
        this.collapsedEditButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new PopupEditDialog(CollapsedListEditorUi.this.context.getValue(), CollapsedListEditorUi.this.expandedUi, CollapsedListEditorUi.this.popupDialogTitle, new DataEntryDialog.DialogCallback<List<ValueType>>(){

                    @Override
                    public void ok(List<ValueType> editedObject) {
                        (this).CollapsedListEditorUi.this.context.setValue(editedObject);
                    }

                    @Override
                    public void cancel() {
                    }
                }).show();
            }
        });
        panel.add((Widget)this.collapsedValuesBox);
        panel.add((Widget)this.collapsedEditButton);
        return panel;
    }

    @Override
    public void refresh() {
        String text = this.getCollapsedValueText((Iterable<ValueType>)this.context.getValue());
        String shortText = text;
        if (shortText.length() > 20) {
            shortText = String.valueOf(shortText.substring(0, 20)) + "...";
        }
        this.collapsedValuesBox.setText(shortText);
        this.collapsedValuesBox.setTitle(text);
    }

    @Override
    public void onRowAdded() {
    }

    @Override
    public void onRowRemoved(int rowIndex) {
    }

    public void setEnabled(boolean enabled) {
        this.collapsedEditButton.setEnabled(enabled);
    }

    private class PopupEditDialog
    extends DataEntryDialog<List<ValueType>> {
        private ListEditorComposite<ValueType> expandedComposite;

        public PopupEditDialog(Iterable<ValueType> initialValues, ExpandedListEditorUi<ValueType> ui, String dialogTitle, DataEntryDialog.DialogCallback<List<ValueType>> callback) {
            super(dialogTitle, "", CollapsedListEditorUi.this.getStringMessages().save(), CollapsedListEditorUi.this.getStringMessages().cancel(), null, callback);
            this.expandedComposite = CollapsedListEditorUi.this.createExpandedUi(initialValues, ui);
        }

        @Override
        protected Widget getAdditionalWidget() {
            return this.expandedComposite;
        }

        @Override
        protected List<ValueType> getResult() {
            return this.expandedComposite.getValue();
        }
    }
}

