/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.dropdown;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.LinkUtil;
import com.sap.sse.gwt.client.controls.dropdown.DropdownHandler;
import com.sap.sse.gwt.client.controls.dropdown.DropdownItem;
import com.sap.sse.gwt.client.controls.dropdown.DropdownResources;

public class Dropdown
extends Composite {
    private static DropdownUiBinder uiBinder = (DropdownUiBinder)GWT.create(DropdownUiBinder.class);
    @UiField
    FlowPanel dropdownContent;
    @UiField
    AnchorElement dropdownTrigger;
    @UiField
    DivElement dropdownDisplayedText;
    @UiField
    DivElement dropdownTitle;
    @UiField
    DivElement dropdownHeadTitleButton;
    @UiField
    SpanElement dropdownHeadTitle;
    @UiField
    HTMLPanel dropdownPanel;
    private final DropdownResources local_res;
    final DropdownHandler dropdownHandler;

    public Dropdown() {
        this((DropdownResources)GWT.create(DropdownResources.class));
    }

    public Dropdown(DropdownResources resources) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.local_res = resources;
        resources.css().ensureInjected();
        this.dropdownHandler = this.createDropdownHandler();
        this.dropdownPanel.addStyleName(this.local_res.css().dropdown_panel());
        this.dropdownTitle.addClassName(this.local_res.css().dropdown());
        this.dropdownTitle.addClassName(this.local_res.css().jsdropdown());
        this.dropdownTrigger.addClassName(this.local_res.css().dropdown_head());
        this.dropdownTrigger.addClassName(this.local_res.css().jsdropdown_head());
        this.dropdownContent.addStyleName(this.local_res.css().dropdown_content());
        this.dropdownContent.addStyleName(this.local_res.css().jsdropdown_content());
        this.dropdownHeadTitle.addClassName(this.local_res.css().dropdown_head_title());
        this.dropdownHeadTitleButton.addClassName(this.local_res.css().dropdown_head_title_button());
    }

    private DropdownHandler createDropdownHandler() {
        return new DropdownHandler((Element)this.dropdownTrigger, (Element)this.dropdownContent.getElement()){

            @Override
            protected void dropdownStateChanged(boolean dropdownShown) {
                if (dropdownShown) {
                    Dropdown.this.dropdownTitle.addClassName(Dropdown.this.local_res.css().jsdropdownactive());
                } else {
                    Dropdown.this.dropdownTitle.removeClassName(Dropdown.this.local_res.css().jsdropdownactive());
                }
            }
        };
    }

    public void hide() {
        this.dropdownHandler.hide();
    }

    public void setDisplayedText(String displayedText) {
        this.dropdownDisplayedText.setInnerText(displayedText);
    }

    public void addItem(String itemText, SafeUri link, boolean selected, final Runnable callback) {
        DropdownItem dropdownItem = new DropdownItem(this.local_res, itemText, link, selected);
        dropdownItem.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (LinkUtil.handleLinkClick((Event)event.getNativeEvent())) {
                    event.preventDefault();
                    if (callback != null) {
                        callback.run();
                    }
                }
            }
        }, ClickEvent.getType());
        this.dropdownContent.add((Widget)dropdownItem);
        if (selected) {
            this.setDisplayedText(itemText);
        }
    }

    static interface DropdownUiBinder
    extends UiBinder<Widget, Dropdown> {
    }
}

