/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.streamlets;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sailing.gwt.ui.simulator.streamlets.PositionDTOWeigher;
import com.sap.sse.common.Distance;

public class PositionDTOWeigher
implements Weigher<Position> {
    private static final long serialVersionUID = -262428237738496818L;
    private final double halfConfidenceDistanceNauticalMiles;
    private final AverageLatitudeProvider averageLatitudeDegProvider;

    public PositionDTOWeigher(Distance halfConfidenceDistance, AverageLatitudeProvider averageLatitudeDegProvider) {
        this.halfConfidenceDistanceNauticalMiles = halfConfidenceDistance.getNauticalMiles();
        this.averageLatitudeDegProvider = averageLatitudeDegProvider;
    }

    private double getCosineOfAverageLatitude() {
        return this.averageLatitudeDegProvider.getCosineOfAverageLatitude();
    }

    public double getConfidence(Position fix, Position request) {
        double distanceConfidence;
        if (fix != null && request != null) {
            double c;
            double x = this.getApproximateNauticalMileDistance(fix, request);
            double y = c = this.halfConfidenceDistanceNauticalMiles;
            distanceConfidence = c / (x + y);
        } else {
            distanceConfidence = 1.0E-4;
        }
        return distanceConfidence;
    }

    private double getApproximateNauticalMileDistance(Position p1, Position p2) {
        double latDiffDeg = Math.abs(p1.getLatDeg() - p2.getLatDeg());
        double normalizedLngDiffDeg = this.getCosineOfAverageLatitude() * Math.abs(p1.getLngDeg() - p2.getLngDeg());
        return Math.sqrt(latDiffDeg * latDiffDeg + normalizedLngDiffDeg * normalizedLngDiffDeg) * 60.0;
    }
}

