/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.SingleRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.raceboard.AbstractRaceBoardMode;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardComponentContext;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.SecurityChildSettingsContext;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorageAndAdditionalSettingsLayers;
import java.util.ArrayList;
import java.util.Date;

public class PlayerMode
extends AbstractRaceBoardMode {
    private static final Duration DURATION_BEFORE_START_TO_SET_TIMER_TO_FOR_REPLAY_RACES = Duration.ONE_SECOND.times(10L);
    private boolean adjustedLeaderboardSettings;
    private boolean timerAdjusted;

    private void adjustLeaderboardSettings() {
        SingleRaceLeaderboardPanel leaderboardPanel = this.getLeaderboardPanel();
        ArrayList<DetailType> raceDetailsToShow = new ArrayList<DetailType>();
        raceDetailsToShow.add(DetailType.RACE_DISPLAY_LEGS);
        raceDetailsToShow.add(DetailType.RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS);
        raceDetailsToShow.add(DetailType.RACE_GAP_TO_LEADER_IN_SECONDS);
        SecurityChildSettingsContext context = new SecurityChildSettingsContext((SecuredDTO)this.getLeaderboard(), leaderboardPanel.getPaywallResolver());
        SingleRaceLeaderboardSettings additiveSettings = SingleRaceLeaderboardSettings.createDefaultSettingsWithRaceDetailValues(raceDetailsToShow, (SecurityChildSettingsContext)context);
        ((RaceBoardComponentContext)leaderboardPanel.getComponentContext()).addModesPatching((Component)leaderboardPanel, (GenericSerializableSettings)additiveSettings, (ComponentContextWithSettingsStorageAndAdditionalSettingsLayers.OnSettingsReloadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void trigger() {
        Date startOfTracking;
        Date startOfRace;
        Object startPlayingAt;
        Timer.PlayModes playMode = this.getTimer().getPlayMode();
        if (playMode == Timer.PlayModes.Live) {
            this.stopReceivingRaceTimesInfos();
        }
        if (!this.timerAdjusted && playMode != Timer.PlayModes.Live && this.getRaceTimesInfoForRace() != null && (startPlayingAt = (startOfRace = this.getRaceTimesInfoForRace().startOfRace) != null ? new MillisecondsTimePoint(startOfRace).minus(DURATION_BEFORE_START_TO_SET_TIMER_TO_FOR_REPLAY_RACES) : ((startOfTracking = this.getRaceTimesInfoForRace().getStartOfTracking()) != null ? new MillisecondsTimePoint(startOfTracking) : null)) != null) {
            this.timerAdjusted = true;
            this.setTimerOrUseCustomStart(startPlayingAt);
            this.getTimer().play();
            this.stopReceivingRaceTimesInfos();
        }
        if (!this.adjustedLeaderboardSettings && this.getLeaderboard() != null) {
            this.adjustedLeaderboardSettings = true;
            this.stopReceivingLeaderboard();
            this.adjustLeaderboardSettings();
        }
    }

    static /* synthetic */ void access$0(PlayerMode playerMode) {
        super.onInitializationFinished();
    }
}

