/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.DisplayedLeaderboardRowsProvider;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import java.util.Collection;
import java.util.Comparator;

public class FormattedDoubleLeaderboardRowDTODetailTypeColumn
extends DetailTypeColumn<Double, String, LeaderboardRowDTO>
implements HasStringAndDoubleValue<LeaderboardRowDTO> {
    private final NumberFormat formatter;
    private final MinMaxRenderer<LeaderboardRowDTO> minMaxRenderer;

    public FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType detailType, DetailTypeColumn.DataExtractor<Double, LeaderboardRowDTO> field, String headerStyle, String columnStyle, DisplayedLeaderboardRowsProvider displayedLeaderboardRowsProvider) {
        super(detailType, field, (Cell)new TextCell(), headerStyle, columnStyle, displayedLeaderboardRowsProvider);
        this.formatter = this.createNumberFormatter(detailType);
        this.minMaxRenderer = this.createMinMaxRenderer();
    }

    protected MinMaxRenderer<LeaderboardRowDTO> createMinMaxRenderer() {
        return new MinMaxRenderer((HasStringAndDoubleValue)this, (Comparator)this.getComparator());
    }

    private NumberFormat createNumberFormatter(DetailType detailType) {
        return NumberFormatterFactory.getDecimalFormat((int)detailType.getPrecision());
    }

    protected MinMaxRenderer<LeaderboardRowDTO> getMinMaxRenderer() {
        return this.minMaxRenderer;
    }

    public void updateMinMax() {
        Collection data = this.getDisplayedLeaderboardRowsProvider().getRowsToDisplay().values();
        this.getMinMaxRenderer().updateMinMax(data);
    }

    protected NumberFormat getFormatter() {
        return this.formatter;
    }

    public String getValue(LeaderboardRowDTO row) {
        Double fieldValue = (Double)this.getFieldValue((Object)row);
        String result = "";
        if (fieldValue != null) {
            result = this.getFormatter().format((Number)fieldValue);
        }
        return result;
    }

    public Double getDoubleValue(LeaderboardRowDTO row) {
        return (Double)this.getFieldValue((Object)row);
    }

    public void render(Cell.Context context, LeaderboardRowDTO row, SafeHtmlBuilder sb) {
        this.getMinMaxRenderer().render(context, (Object)row, this.getTitle(row), sb);
    }

    protected String getTitle(LeaderboardRowDTO row) {
        return null;
    }

    public String getStringValueToRender(LeaderboardRowDTO object) {
        String value = this.getValue(object);
        if (value != null && !value.isEmpty()) {
            return this.getValue(object);
        }
        return null;
    }
}

