/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.gwt.common.client.suggestion.BoatClassMasterdataSuggestOracle;
import com.sap.sailing.gwt.ui.adminconsole.AbstractRegattaWithSeriesAndFleetsDialog;
import com.sap.sailing.gwt.ui.adminconsole.SeriesWithFleetsListEditor;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.listedit.ListEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;

public abstract class RegattaWithSeriesAndFleetsDialog
extends AbstractRegattaWithSeriesAndFleetsDialog<RegattaDTO> {
    protected TextBox nameEntryField;
    protected SuggestBox boatClassEntryField;
    protected CheckBox canBoatsOfCompetitorsChangePerRaceCheckBox;

    public RegattaWithSeriesAndFleetsDialog(RegattaDTO regatta, Iterable<SeriesDTO> series, Iterable<EventDTO> existingEvents, EventDTO defaultEvent, String title, String okButton, SailingServiceAsync sailingService, UserService userService, StringMessages stringMessages, DataEntryDialog.Validator<RegattaDTO> validator, DataEntryDialog.DialogCallback<RegattaDTO> callback) {
        super(sailingService, userService, regatta, series, existingEvents, defaultEvent, title, okButton, stringMessages, validator, callback);
        this.stringMessages = stringMessages;
        this.nameEntryField = this.createTextBox(null);
        this.nameEntryField.ensureDebugId("NameTextBox");
        this.nameEntryField.setVisibleLength(40);
        this.nameEntryField.setText(regatta.getName());
        this.boatClassEntryField = this.createSuggestBox((SuggestOracle)new BoatClassMasterdataSuggestOracle());
        this.boatClassEntryField.getValueBox().ensureDebugId("BoatClassTextBox");
        if (regatta.boatClass != null) {
            this.boatClassEntryField.setText(regatta.boatClass.getName());
        }
        this.canBoatsOfCompetitorsChangePerRaceCheckBox = this.createCheckbox("");
        this.canBoatsOfCompetitorsChangePerRaceCheckBox.ensureDebugId("CanBoatsOfCompetitorsChangePerRaceCheckBox");
        this.canBoatsOfCompetitorsChangePerRaceCheckBox.setValue(Boolean.valueOf(regatta.canBoatsOfCompetitorsChangePerRace));
    }

    protected ListEditorComposite<SeriesDTO> createSeriesEditor(Iterable<SeriesDTO> series) {
        return new SeriesWithFleetsListEditor(series, this.stringMessages, IconResources.INSTANCE.removeIcon(), this.isEnableFleetRemoval());
    }

    protected abstract boolean isEnableFleetRemoval();

    protected RegattaDTO getResult() {
        RegattaDTO result = this.getRegattaDTO(this.nameEntryField.getText().trim());
        result.boatClass = new BoatClassDTO(this.boatClassEntryField.getText(), (Distance)Distance.NULL, (Distance)Distance.NULL);
        result.canBoatsOfCompetitorsChangePerRace = this.canBoatsOfCompetitorsChangePerRaceCheckBox.getValue();
        return result;
    }

    protected void setupAdditionalWidgetsOnPanel(VerticalPanel panel, Grid formGrid) {
        formGrid.insertRow(0);
        formGrid.insertRow(0);
        formGrid.insertRow(0);
        formGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.name()) + ":"));
        formGrid.setWidget(0, 1, (Widget)this.nameEntryField);
        formGrid.setWidget(1, 0, (Widget)new Label(String.valueOf(this.stringMessages.boatClass()) + ":"));
        formGrid.setWidget(1, 1, (Widget)this.boatClassEntryField);
        formGrid.setWidget(2, 0, (Widget)new Label(String.valueOf(this.stringMessages.canBoatsOfCompetitorsChangePerRace()) + ":"));
        formGrid.setWidget(2, 1, (Widget)this.canBoatsOfCompetitorsChangePerRaceCheckBox);
    }
}

