/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.racelog.tracking.QRCodeURLCreationException;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.controls.QRCodeComposite;

public abstract class BaseQRIdentifierWidget
implements IsWidget {
    protected final TextBox serverBox;
    protected final Grid inputGrid;
    private final QRCodeComposite qrCodeComposite;
    private final Widget baseWidget;
    private final Label error;
    final Label url;
    private RegExp urlValidator = null;
    private RegExp urlPlusTldValidator = null;
    StringMessages stringMessages;

    public BaseQRIdentifierWidget(int qrCodeSize, StringMessages stringMessages) {
        this(qrCodeSize, stringMessages, 2);
    }

    public BaseQRIdentifierWidget(int qrCodeSize, StringMessages stringMessages, int errorCorrectionLevel) {
        this.stringMessages = stringMessages;
        this.serverBox = new TextBox();
        this.serverBox.setVisibleLength(40);
        this.serverBox.setValue((Object)(String.valueOf(Window.Location.getProtocol()) + "//" + Window.Location.getHost()));
        this.serverBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.serverBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.inputGrid = new Grid(1, 2);
        this.inputGrid.setWidget(0, 0, (Widget)new Label(String.valueOf(stringMessages.serverUrl()) + ":"));
        this.inputGrid.setWidget(0, 1, (Widget)this.serverBox);
        this.qrCodeComposite = new QRCodeComposite(qrCodeSize, errorCorrectionLevel);
        this.error = new Label();
        this.error.setStyleName("errorLabel");
        this.url = new Label();
        this.url.ensureDebugId("QRIdentifierURL");
        VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)this.inputGrid);
        panel.add((Widget)this.qrCodeComposite);
        panel.setCellHorizontalAlignment((Widget)this.qrCodeComposite, HasHorizontalAlignment.ALIGN_CENTER);
        panel.add((Widget)this.error);
        panel.add((Widget)this.url);
        this.baseWidget = panel;
    }

    public Widget asWidget() {
        return this.baseWidget;
    }

    protected abstract String generateEncodedQRCodeContent() throws QRCodeURLCreationException;

    public void generateQRCode() {
        try {
            String qrCodeUrl = this.generateEncodedQRCodeContent();
            this.qrCodeComposite.setQrCodeContent(qrCodeUrl);
            this.error.setText("");
            this.url.setText(qrCodeUrl);
        }
        catch (QRCodeURLCreationException e) {
            this.setError(e.getMessage());
        }
    }

    protected String getServerUrlWithoutFinalSlash() {
        String serverUrl = this.serverBox.getValue();
        String result = serverUrl.endsWith("/") ? serverUrl.substring(0, serverUrl.length() - 1) : serverUrl;
        return result;
    }

    private boolean isValidUrl(String url, boolean topLevelDomainRequired) {
        if (this.urlValidator == null || this.urlPlusTldValidator == null) {
            this.urlValidator = RegExp.compile((String)"^((ftp|http|https)://[\\w@.\\-\\_]+(:\\d{1,5})?(/[\\w#!:.?+=&%@!\\_\\-/]+)*){1}$");
            this.urlPlusTldValidator = RegExp.compile((String)"^((ftp|http|https)://[\\w@.\\-\\_]+\\.[a-zA-Z]{2,}(:\\d{1,5})?(/[\\w#!:.?+=&%@!\\_\\-/]+)*){1}$");
        }
        return (topLevelDomainRequired ? this.urlPlusTldValidator : this.urlValidator).exec(url) != null;
    }

    public boolean isServerUrlValid() {
        String url = this.getServerUrlWithoutFinalSlash();
        return this.isValidUrl(url, false);
    }

    protected void clear() {
        this.qrCodeComposite.clearQRCode();
        this.url.setText("");
    }

    protected void setError(String text) {
        this.error.setText(text);
        this.qrCodeComposite.clearQRCode();
    }
}

