/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.fakeseries;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.fakeseries.EventSeriesViewDTO;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.shared.media.ImageDescriptor;
import java.io.Serializable;
import java.util.UUID;

public class GetEventSeriesViewAction
implements SailingAction<EventSeriesViewDTO>,
IsClientCacheable {
    private UUID seriesUUIDOrNull;
    private UUID leaderboardGroupUUIDOrNull;

    private GetEventSeriesViewAction() {
    }

    public GetEventSeriesViewAction(UUID leaderboardGroupUUID) {
        this.leaderboardGroupUUIDOrNull = leaderboardGroupUUID;
        if (leaderboardGroupUUID == null) {
            throw new RuntimeException("leaderboardgroupid is known");
        }
    }

    public GetEventSeriesViewAction(SeriesContext ctx) {
        this.leaderboardGroupUUIDOrNull = ctx.getLeaderboardGroupId();
        if (this.leaderboardGroupUUIDOrNull == null) {
            if (ctx.getSeriesId() == null) {
                throw new RuntimeException("invalid context, neither seriesid not leaderboardgroupid is known");
            }
            this.seriesUUIDOrNull = ctx.getSeriesId();
        }
    }

    @GwtIncompatible
    public EventSeriesViewDTO execute(SailingDispatchContext ctx) throws DispatchException {
        Event o;
        LeaderboardGroup leaderBoardGroup;
        if (this.leaderboardGroupUUIDOrNull != null) {
            leaderBoardGroup = ctx.getRacingEventService().getLeaderboardGroupByID(this.leaderboardGroupUUIDOrNull);
            if (leaderBoardGroup == null) {
                throw new RuntimeException("LeaderboardGroup not found");
            }
            o = HomeServiceUtil.determineBestMatchingEvent((RacingEventService)ctx.getRacingEventService(), (LeaderboardGroup)leaderBoardGroup);
        } else {
            o = ctx.getRacingEventService().getEvent((Serializable)this.seriesUUIDOrNull);
            if (o == null) {
                throw new RuntimeException("Series not found");
            }
            if (Util.size((Iterable)o.getLeaderboardGroups()) != 1) {
                throw new RuntimeException("Could not map event to LeaderboardGroup");
            }
            leaderBoardGroup = (LeaderboardGroup)o.getLeaderboardGroups().iterator().next();
        }
        if (!leaderBoardGroup.hasOverallLeaderboard()) {
            throw new RuntimeException("Is not overall leaderboard");
        }
        EventSeriesViewDTO dto = new EventSeriesViewDTO();
        dto.setLeaderboardGroupUUID(leaderBoardGroup.getId());
        ImageDescriptor logoImage = o.findImageWithTag(MediaTagConstants.LOGO.getName());
        dto.setLogoImage(logoImage != null ? HomeServiceUtil.convertToImageDTO((ImageDescriptor)logoImage) : null);
        dto.setHasMedia(false);
        boolean oneEventStarted = false;
        boolean oneEventLive = false;
        boolean allFinished = true;
        dto.setDisplayName(leaderBoardGroup.getDisplayName() != null ? leaderBoardGroup.getDisplayName() : leaderBoardGroup.getName());
        if (leaderBoardGroup.getOverallLeaderboard() != null) {
            dto.setLeaderboardId(leaderBoardGroup.getOverallLeaderboard().getName());
        }
        for (Event eventInSeries : HomeServiceUtil.getEventsForSeriesOrdered((LeaderboardGroup)leaderBoardGroup, (RacingEventService)ctx.getRacingEventService())) {
            EventMetadataDTO eventOfSeries = HomeServiceUtil.convertToMetadataDTO((EventBase)eventInSeries);
            dto.addEvent(eventOfSeries);
            oneEventStarted |= eventOfSeries.isStarted();
            oneEventLive |= eventOfSeries.isStarted() && !eventOfSeries.isFinished();
            allFinished &= eventOfSeries.isFinished();
        }
        HomeServiceUtil.getEventAndLeaderboardReferencesForSeriesOrdered((LeaderboardGroup)leaderBoardGroup, (RacingEventService)ctx.getRacingEventService()).forEach(arg_0 -> ((EventSeriesViewDTO)dto).addEventAndLeaderboard(arg_0));
        if (oneEventLive) {
            dto.setState(EventSeriesViewDTO.EventSeriesState.RUNNING);
        } else if (!oneEventStarted) {
            dto.setState(EventSeriesViewDTO.EventSeriesState.UPCOMING);
        } else if (allFinished) {
            dto.setState(EventSeriesViewDTO.EventSeriesState.FINISHED);
        } else {
            dto.setState(EventSeriesViewDTO.EventSeriesState.IN_PROGRESS);
        }
        dto.setHasAnalytics(oneEventStarted);
        return dto;
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.leaderboardGroupUUIDOrNull);
        key.append(this.seriesUUIDOrNull);
    }
}

