/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.statistics.EventStatisticsDTO;
import com.sap.sailing.gwt.home.server.StatisticsCalculator;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.util.UUID;

public class GetSeriesStatisticsAction
implements SailingAction<ResultWithTTL<EventStatisticsDTO>>,
IsClientCacheable {
    private UUID seriesLeaderboardGroupId;

    protected GetSeriesStatisticsAction() {
    }

    public GetSeriesStatisticsAction(UUID seriesLeaderboardGroupId) {
        this.seriesLeaderboardGroupId = seriesLeaderboardGroupId;
    }

    @GwtIncompatible
    public ResultWithTTL<EventStatisticsDTO> execute(SailingDispatchContext context) throws DispatchException {
        StatisticsCalculator statisticsCalculator = new StatisticsCalculator(context.getTrackedRaceStatisticsCache());
        LeaderboardGroup leaderboardGroupByID = context.getRacingEventService().getLeaderboardGroupByID(this.seriesLeaderboardGroupId);
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroupByID);
        leaderboardGroupByID.getLeaderboards().forEach(t -> {
            if (context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)t)) {
                statisticsCalculator.addLeaderboard(t);
            }
        });
        return statisticsCalculator.getResult();
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.seriesLeaderboardGroupId);
    }
}

