/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.app;

import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.autoplay.client.app.AutoplayPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public class AutoplaySettingsDialogComponent
implements SettingsDialogComponent<AutoplayPerspectiveOwnSettings> {
    private final AutoplayPerspectiveOwnSettings initialSettings;
    private final StringMessages stringMessages;
    private CheckBox fullScreen;
    private CheckBox switchToLiveRaceAutomatically;
    private IntegerBox timeBeforeRaceStartInput;
    private IntegerBox waitTimeAfterRaceEndInput;

    AutoplaySettingsDialogComponent(AutoplayPerspectiveOwnSettings settings) {
        this.initialSettings = settings;
        this.stringMessages = StringMessages.INSTANCE;
    }

    public Widget getAdditionalWidget(DataEntryDialog<?> dialog) {
        VerticalPanel vp = new VerticalPanel();
        this.fullScreen = dialog.createCheckbox(this.stringMessages.startBrowserFullscreen());
        this.fullScreen.setValue(Boolean.valueOf(this.initialSettings.isFullscreen()));
        vp.add((Widget)this.fullScreen);
        this.switchToLiveRaceAutomatically = dialog.createCheckbox(this.stringMessages.switchToLiveRaceAutomatically());
        this.switchToLiveRaceAutomatically.setValue(Boolean.valueOf(this.initialSettings.isSwitchToLive()));
        vp.add((Widget)this.switchToLiveRaceAutomatically);
        Label timeBeforeRaceStartDescription = new Label(this.stringMessages.timeBeforeRaceStart());
        vp.add((Widget)timeBeforeRaceStartDescription);
        this.timeBeforeRaceStartInput = dialog.createIntegerBox(Integer.valueOf(this.initialSettings.getTimeToSwitchBeforeRaceStartInSeconds()), 5);
        vp.add((Widget)this.timeBeforeRaceStartInput);
        Label timeAfterRaceEndDescription = new Label(this.stringMessages.timeAfterRaceEnd());
        vp.add((Widget)timeAfterRaceEndDescription);
        this.waitTimeAfterRaceEndInput = dialog.createIntegerBox(Integer.valueOf(this.initialSettings.getWaitTimeAfterRaceEndInSeconds()), 5);
        vp.add((Widget)this.waitTimeAfterRaceEndInput);
        return vp;
    }

    public AutoplayPerspectiveOwnSettings getResult() {
        return new AutoplayPerspectiveOwnSettings(this.fullScreen.getValue().booleanValue(), this.switchToLiveRaceAutomatically.getValue().booleanValue(), ((Integer)this.timeBeforeRaceStartInput.getValue()).intValue(), ((Integer)this.waitTimeAfterRaceEndInput.getValue()).intValue());
    }

    public DataEntryDialog.Validator<AutoplayPerspectiveOwnSettings> getValidator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public FocusWidget getFocusWidget() {
        return this.fullScreen;
    }

    static /* synthetic */ StringMessages access$1(AutoplaySettingsDialogComponent autoplaySettingsDialogComponent) {
        return autoplaySettingsDialogComponent.stringMessages;
    }
}

