/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.windinference;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.util.WindUtil;
import com.sap.sailing.windestimation.windinference.TwdFromManeuverCalculator;
import com.sap.sailing.windestimation.windinference.TwsFromManeuverCalculator;
import com.sap.sailing.windestimation.windinference.WindTrackCalculator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;

public class WindTrackCalculatorImpl
implements WindTrackCalculator {
    private final TwdFromManeuverCalculator twdCalculator;
    private final TwsFromManeuverCalculator twsCalculator;

    public WindTrackCalculatorImpl(TwdFromManeuverCalculator twdCalculator, TwsFromManeuverCalculator twsCalculator) {
        this.twdCalculator = twdCalculator;
        this.twsCalculator = twsCalculator;
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> getWindTrackFromManeuverClassifications(List<ManeuverWithEstimatedType> improvedManeuverClassifications) {
        List<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixes = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>();
        for (ManeuverWithEstimatedType maneuverWithEstimatedType : improvedManeuverClassifications) {
            Bearing windFrom = this.twdCalculator.getTwd(maneuverWithEstimatedType);
            if (windFrom == null) continue;
            Bearing windTo = windFrom.reverse();
            ManeuverForEstimation maneuver = maneuverWithEstimatedType.getManeuver();
            Speed avgWindSpeed = this.twsCalculator.getWindSpeed(maneuver, windTo);
            WindImpl wind = new WindImpl(maneuver.getManeuverPosition(), maneuver.getManeuverTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(avgWindSpeed.getKnots(), windTo));
            windFixes.add((WindWithConfidence<Util.Pair<Position, TimePoint>>)new WindWithConfidenceImpl((Wind)wind, maneuverWithEstimatedType.getConfidence(), (Object)new Util.Pair((Object)wind.getPosition(), (Object)wind.getTimePoint()), avgWindSpeed.getKnots() > 0.0));
        }
        windFixes = WindUtil.getWindFixesWithMedianTws(windFixes);
        return windFixes;
    }
}

