/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.outlierremoval;

import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.aggregator.outlierremoval.OutlierAnalysisResult;
import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.util.ManeuverUtil;
import com.sap.sailing.windestimation.windinference.TwdFromManeuverCalculator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractOutlierRemovalWindEstimator
implements ManeuverClassificationsAggregator {
    public static final double MAX_DEVIATON_FROM_AVG_WIND_COURSE = 30.0;
    private final TwdFromManeuverCalculator twdCalculator;

    public AbstractOutlierRemovalWindEstimator(TwdFromManeuverCalculator twdCalculator) {
        this.twdCalculator = twdCalculator;
    }

    @Override
    public List<ManeuverWithEstimatedType> aggregateManeuverClassifications(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications) {
        List<Util.Pair<Bearing, ManeuverWithEstimatedType>> twdWithManeuvers = this.extractUsefulManeuversWithTwd(raceWithManeuverClassifications.getCompetitorTracks());
        OutlierAnalysisResult outlierAnalysisResult = this.analyzeOutlier(twdWithManeuvers);
        List<ManeuverWithEstimatedType> result = ManeuverUtil.getManeuverWithEstimatedTypeWithFixedConfidence(outlierAnalysisResult.getIncludedManeuvers(), outlierAnalysisResult.getFinalConfidence());
        return result;
    }

    protected abstract OutlierAnalysisResult analyzeOutlier(List<Util.Pair<Bearing, ManeuverWithEstimatedType>> var1);

    private List<Util.Pair<Bearing, ManeuverWithEstimatedType>> extractUsefulManeuversWithTwd(List<CompetitorTrackWithEstimationData<ManeuverWithProbabilisticTypeClassification>> competitorTracks) {
        ArrayList<Util.Pair<Bearing, ManeuverWithEstimatedType>> twdsWithManeuvers = new ArrayList<Util.Pair<Bearing, ManeuverWithEstimatedType>>();
        for (CompetitorTrackWithEstimationData<ManeuverWithProbabilisticTypeClassification> competitorTrack : competitorTracks) {
            for (ManeuverWithProbabilisticTypeClassification estimationResult : competitorTrack.getElements()) {
                double highestLikelihood = 0.0;
                ManeuverTypeForClassification maneuverTypeWithHighestLikelihood = null;
                ManeuverTypeForClassification[] maneuverTypeForClassificationArray = ManeuverTypeForClassification.values();
                int n = maneuverTypeForClassificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ManeuverTypeForClassification maneuverType = maneuverTypeForClassificationArray[n2];
                    double likelihood = estimationResult.getManeuverTypeLikelihood(maneuverType);
                    if (highestLikelihood < likelihood) {
                        highestLikelihood = likelihood;
                        maneuverTypeWithHighestLikelihood = maneuverType;
                    }
                    ++n2;
                }
                if (maneuverTypeWithHighestLikelihood != ManeuverTypeForClassification.TACK && maneuverTypeWithHighestLikelihood != ManeuverTypeForClassification.JIBE) continue;
                ManeuverWithEstimatedType maneuverWithEstimatedType = new ManeuverWithEstimatedType(estimationResult.getManeuver(), maneuverTypeWithHighestLikelihood, highestLikelihood);
                Bearing twd = this.twdCalculator.getTwd(maneuverWithEstimatedType);
                twdsWithManeuvers.add((Util.Pair<Bearing, ManeuverWithEstimatedType>)new Util.Pair((Object)twd, (Object)maneuverWithEstimatedType));
            }
        }
        return twdsWithManeuvers;
    }
}

