/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.windestimation.WindEstimationComponentWithInternals;
import com.sap.sailing.windestimation.aggregator.ManeuverClassificationsAggregator;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifiersCache;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.preprocessing.PreprocessingPipeline;
import com.sap.sailing.windestimation.windinference.WindTrackCalculator;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.stream.Collectors;

public class ManeuverBasedWindEstimationComponentImpl<InputType>
implements WindEstimationComponentWithInternals<InputType> {
    private final PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> preprocessingPipeline;
    private final ManeuverClassifiersCache maneuverClassifiersCache;
    private final ManeuverClassificationsAggregator maneuverClassificationsAggregator;
    private final WindTrackCalculator windTrackCalculator;

    public ManeuverBasedWindEstimationComponentImpl(PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> preprocessingPipeline, ManeuverClassifiersCache maneuverClassifiersCache, ManeuverClassificationsAggregator maneuverClassificationsAggregator, WindTrackCalculator windTrackCalculator) {
        this.preprocessingPipeline = preprocessingPipeline;
        this.maneuverClassifiersCache = maneuverClassifiersCache;
        this.maneuverClassificationsAggregator = maneuverClassificationsAggregator;
        this.windTrackCalculator = windTrackCalculator;
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrack(InputType input) {
        RaceWithEstimationData<ManeuverForEstimation> race = this.preprocessingPipeline.preprocessInput(input);
        return this.estimateWindTrackAfterPreprocessing(race);
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterPreprocessing(RaceWithEstimationData<ManeuverForEstimation> race) {
        List competitorTracks = race.getCompetitorTracks().stream().map(competitorTrack -> {
            List maneuverClassifications = competitorTrack.getElements().stream().map(maneuver -> (ManeuverWithProbabilisticTypeClassification)this.maneuverClassifiersCache.classifyInstance(maneuver)).collect(Collectors.toList());
            return competitorTrack.constructWithElements(maneuverClassifications);
        }).collect(Collectors.toList());
        RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications = race.constructWithElements(competitorTracks);
        return this.estimateWindTrackAfterManeuverClassification(raceWithManeuverClassifications);
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterManeuverClassification(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuverClassifications) {
        List<ManeuverWithEstimatedType> improvedManeuverClassifications = this.maneuverClassificationsAggregator.aggregateManeuverClassifications(raceWithManeuverClassifications);
        return this.estimateWindTrackAfterManeuverClassificationsAggregation(improvedManeuverClassifications);
    }

    @Override
    public List<WindWithConfidence<Util.Pair<Position, TimePoint>>> estimateWindTrackAfterManeuverClassificationsAggregation(List<ManeuverWithEstimatedType> improvedManeuverClassifications) {
        List<WindWithConfidence<Util.Pair<Position, TimePoint>>> windTrack = this.windTrackCalculator.getWindTrackFromManeuverClassifications(improvedManeuverClassifications);
        return windTrack;
    }

    @Override
    public PreprocessingPipeline<InputType, RaceWithEstimationData<ManeuverForEstimation>> getPreprocessingPipeline() {
        return this.preprocessingPipeline;
    }

    @Override
    public ManeuverClassificationsAggregator getManeuverClassificationsAggregator() {
        return this.maneuverClassificationsAggregator;
    }

    @Override
    public ManeuverClassifiersCache getManeuverClassifiersCache() {
        return this.maneuverClassifiersCache;
    }

    @Override
    public WindTrackCalculator getWindTrackCalculator() {
        return this.windTrackCalculator;
    }
}

