/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.confidence.ConfidenceFactory;
import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class PositionAndTimePointWeigher
implements Weigher<Util.Pair<Position, TimePoint>> {
    private static final String USE_POSITION_SYSTEM_PROPERTY_NAME = "spatialWind";
    private static final long serialVersionUID = -262428237738496818L;
    private final Weigher<TimePoint> timeWeigher;
    private final Weigher<Position> distanceWeigher;
    private final boolean usePosition;

    public PositionAndTimePointWeigher(Duration halfConfidenceAfter, Distance halfConfidenceDistance) {
        this.timeWeigher = ConfidenceFactory.INSTANCE.createHyperbolicTimeDifferenceWeigher(halfConfidenceAfter.asMillis());
        this.distanceWeigher = ConfidenceFactory.INSTANCE.createHyperbolicDistanceWeigher(halfConfidenceDistance);
        this.usePosition = Boolean.valueOf(System.getProperty(USE_POSITION_SYSTEM_PROPERTY_NAME, "true"));
    }

    @Override
    public double getConfidence(Util.Pair<Position, TimePoint> fix, Util.Pair<Position, TimePoint> reference) {
        double timeConfidence = this.timeWeigher.getConfidence((TimePoint)fix.getB(), (TimePoint)reference.getB());
        double distanceConfidence = this.usePosition && reference != null ? (fix.getA() != null && reference.getA() != null ? this.distanceWeigher.getConfidence((Position)fix.getA(), (Position)reference.getA()) : 0.1) : 1.0;
        return timeConfidence * distanceConfidence;
    }
}

