/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class WindFieldGeneratorMeasured
extends WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final Logger LOGGER = Logger.getLogger("com.sap.sailing.simulator");
    private static final long serialVersionUID = -7436152672809530764L;
    protected Path gpsWind;

    public WindFieldGeneratorMeasured(Grid boundary, WindControlParameters windParameters) {
        super(boundary, windParameters);
    }

    public void setGPSWind(Path gpsWind) {
        this.gpsWind = gpsWind;
    }

    @Override
    public void generate(TimePoint start, TimePoint end, Duration step) {
        super.generate(start, end, step);
    }

    @Override
    public Wind getWind(TimedPosition timedPosition) {
        Bearing b2;
        SpeedWithBearing s2;
        Bearing b1;
        SpeedWithBearing s1;
        TimePoint timePoint = timedPosition.getTimePoint();
        TimedPositionWithSpeed p1 = null;
        TimedPositionWithSpeed p2 = null;
        List<TimedPositionWithSpeed> pathPoints = this.gpsWind.getPathPoints();
        Iterator<TimedPositionWithSpeed> iterator = pathPoints.iterator();
        while (iterator.hasNext()) {
            TimedPositionWithSpeed p;
            p2 = p = iterator.next();
            if (p.getTimePoint().after(timePoint)) break;
            p1 = p;
        }
        String errorMessage = null;
        if (p1 == null) {
            errorMessage = "ERROR: couldn't find the before time point, interpolation will now fail!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        if (p2 == null) {
            errorMessage = "ERROR: couldn't find the after time point, interpolation will now fail!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        if ((s1 = p1.getSpeed()) == null) {
            errorMessage = "ERROR: p1.getSpeed() is null!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        if ((b1 = s1.getBearing()) == null) {
            errorMessage = "ERROR: p1.getSpeed().getBearing(); is null!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        if ((s2 = p2.getSpeed()) == null) {
            errorMessage = "ERROR: p2.getSpeed() is null!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        if ((b2 = s2.getBearing()) == null) {
            errorMessage = "ERROR: p2.getSpeed().getBearing(); is null!";
            System.out.println(errorMessage);
            LOGGER.severe(errorMessage);
        }
        DegreeBearingImpl midBear = new DegreeBearingImpl((b1.getDegrees() + b2.getDegrees()) / 2.0);
        KnotSpeedWithBearingImpl speedWithBearing = new KnotSpeedWithBearingImpl((p1.getSpeed().getKnots() + p2.getSpeed().getKnots()) / 2.0, (Bearing)midBear);
        return new WindImpl(timedPosition.getPosition(), timedPosition.getTimePoint(), (SpeedWithBearing)speedWithBearing);
    }
}

