/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.simulator.impl.PolarDiagramBase;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class PolarDiagramGPS
extends PolarDiagramBase {
    private static final Logger logger = Logger.getLogger(PolarDiagramGPS.class.getName());
    private static final long serialVersionUID = -9219705955440602679L;
    private double avgSpeedInKnots;
    private final double WIND_DIRECTION_STEPS_IN_DEGREES = 10.0;

    public PolarDiagramGPS(BoatClass boatClass, PolarDataService polarData) throws SparseSimulationDataException {
        this.boatClass = boatClass;
        ArrayList<KnotSpeedImpl> windSpeeds = new ArrayList<KnotSpeedImpl>();
        ArrayList<DegreeBearingImpl> beatAngles = new ArrayList<DegreeBearingImpl>();
        ArrayList<KnotSpeedImpl> beatSpeed = new ArrayList<KnotSpeedImpl>();
        HashMap<Bearing, List> speeds = new HashMap<Bearing, List>();
        ArrayList<KnotSpeedImpl> jibeSpeed = new ArrayList<KnotSpeedImpl>();
        ArrayList<DegreeBearingImpl> jibeAngles = new ArrayList<DegreeBearingImpl>();
        windSpeeds.add(new KnotSpeedImpl(0.0));
        windSpeeds.add(new KnotSpeedImpl(6.0));
        windSpeeds.add(new KnotSpeedImpl(8.0));
        windSpeeds.add(new KnotSpeedImpl(10.0));
        windSpeeds.add(new KnotSpeedImpl(12.0));
        windSpeeds.add(new KnotSpeedImpl(14.0));
        windSpeeds.add(new KnotSpeedImpl(16.0));
        windSpeeds.add(new KnotSpeedImpl(18.0));
        windSpeeds.add(new KnotSpeedImpl(20.0));
        windSpeeds.add(new KnotSpeedImpl(22.0));
        windSpeeds.add(new KnotSpeedImpl(24.0));
        int avgCount = 0;
        this.avgSpeedInKnots = 0.0;
        int i = 0;
        while (i < windSpeeds.size()) {
            SpeedWithBearing beatStar;
            SpeedWithBearing beatPort;
            Speed windSpeed = (Speed)windSpeeds.get(i);
            double twaInDegrees = 0.0;
            while (twaInDegrees <= 180.0) {
                DegreeBearingImpl portBearing = new DegreeBearingImpl(-twaInDegrees);
                List boatSpeedLineForWindSpeedPort = speeds.computeIfAbsent((Bearing)portBearing, key -> new ArrayList());
                try {
                    Speed portSpeed = (Speed)polarData.getSpeed(boatClass, windSpeed, (Bearing)portBearing).getObject();
                    if (portSpeed.getKnots() < 0.0) {
                        boatSpeedLineForWindSpeedPort.add(Speed.NULL);
                    } else {
                        boatSpeedLineForWindSpeedPort.add(portSpeed);
                    }
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    logger.fine(() -> PolarDiagramGPS.lambda$1(boatClass, windSpeed, (Bearing)portBearing));
                    boatSpeedLineForWindSpeedPort.add(Speed.NULL);
                }
                DegreeBearingImpl starboardBearing = new DegreeBearingImpl(twaInDegrees);
                List boatSpeedLineForWindSpeedStarboard = speeds.computeIfAbsent((Bearing)starboardBearing, key -> new ArrayList());
                try {
                    Speed starboardSpeed = (Speed)polarData.getSpeed(boatClass, windSpeed, (Bearing)starboardBearing).getObject();
                    if (starboardSpeed.getKnots() < 0.0) {
                        boatSpeedLineForWindSpeedStarboard.add(Speed.NULL);
                    } else {
                        boatSpeedLineForWindSpeedStarboard.add(starboardSpeed);
                    }
                }
                catch (NotEnoughDataHasBeenAddedException e) {
                    logger.fine(() -> PolarDiagramGPS.lambda$3(boatClass, windSpeed, (Bearing)starboardBearing));
                    boatSpeedLineForWindSpeedStarboard.add(Speed.NULL);
                }
                twaInDegrees += 10.0;
            }
            try {
                beatPort = polarData.getAverageSpeedWithTrueWindAngle(this.boatClass, windSpeed, LegType.UPWIND, Tack.PORT).getObject();
                beatStar = polarData.getAverageSpeedWithTrueWindAngle(this.boatClass, windSpeed, LegType.UPWIND, Tack.STARBOARD).getObject();
            }
            catch (NotEnoughDataHasBeenAddedException e) {
                beatPort = null;
                beatStar = null;
            }
            if (beatStar != null) {
                double beatStarAngle = Math.abs((beatStar.getBearing().getDegrees() + 180.0) % 360.0 - 180.0);
                double beatPortAngle = Math.abs((beatPort.getBearing().getDegrees() + 180.0) % 360.0 - 180.0);
                DegreeBearingImpl avgBeatAngle = new DegreeBearingImpl((beatStarAngle + beatPortAngle) / 2.0);
                beatAngles.add(avgBeatAngle);
                KnotSpeedImpl avgBeatSpeed = new KnotSpeedImpl((beatStar.getKnots() + beatPort.getKnots()) / 2.0);
                beatSpeed.add(avgBeatSpeed);
                this.avgSpeedInKnots += avgBeatSpeed.getKnots();
                ++avgCount;
            } else {
                beatAngles.add(null);
                beatSpeed.add(null);
            }
            ++i;
        }
        this.avgSpeedInKnots /= (double)avgCount;
        int i2 = 0;
        while (i2 < windSpeeds.size()) {
            SpeedWithBearing jibeStar;
            SpeedWithBearing jibePort;
            try {
                jibePort = polarData.getAverageSpeedWithTrueWindAngle(this.boatClass, (Speed)windSpeeds.get(i2), LegType.DOWNWIND, Tack.PORT).getObject();
                jibeStar = polarData.getAverageSpeedWithTrueWindAngle(this.boatClass, (Speed)windSpeeds.get(i2), LegType.DOWNWIND, Tack.STARBOARD).getObject();
            }
            catch (NotEnoughDataHasBeenAddedException e) {
                jibePort = null;
                jibeStar = null;
            }
            if (jibeStar != null) {
                double jibeStarAngle = Math.abs((jibeStar.getBearing().getDegrees() + 180.0) % 360.0 - 180.0);
                double jibePortAngle = Math.abs((jibePort.getBearing().getDegrees() + 180.0) % 360.0 - 180.0);
                DegreeBearingImpl avgJibeAngle = new DegreeBearingImpl((jibeStarAngle + jibePortAngle) / 2.0);
                jibeAngles.add(avgJibeAngle);
                KnotSpeedImpl avgJibeSpeed = new KnotSpeedImpl((jibeStar.getKnots() + jibePort.getKnots()) / 2.0);
                jibeSpeed.add(avgJibeSpeed);
            } else {
                jibeAngles.add(null);
                jibeSpeed.add(null);
            }
            ++i2;
        }
        TreeMap<Speed, NavigableMap<Bearing, Speed>> mapSpeedTable = new TreeMap<Speed, NavigableMap<Bearing, Speed>>();
        TreeMap<Speed, Bearing> mapBeatAngles = new TreeMap<Speed, Bearing>();
        TreeMap<Speed, Bearing> mapJibeAngles = new TreeMap<Speed, Bearing>();
        TreeMap<Speed, Speed> mapBeatSOG = new TreeMap<Speed, Speed>();
        TreeMap<Speed, Speed> mapJibeSOG = new TreeMap<Speed, Speed>();
        Speed windSpeed = null;
        Speed boatSpeed = null;
        TreeMap<Bearing, Speed> speedTableLine = null;
        int index = 0;
        while (index < windSpeeds.size()) {
            windSpeed = (Speed)windSpeeds.get(index);
            if (windSpeed.getKnots() == 0.0) {
                mapBeatSOG.put((Speed)new KnotSpeedImpl(0.0), (Speed)new KnotSpeedImpl(0.0));
                mapJibeSOG.put((Speed)new KnotSpeedImpl(0.0), (Speed)new KnotSpeedImpl(0.0));
            }
            speedTableLine = new TreeMap<Bearing, Speed>(bearingComparator);
            for (Map.Entry entry : speeds.entrySet()) {
                if (index >= ((List)entry.getValue()).size() || (boatSpeed = (Speed)((List)entry.getValue()).get(index)) == Speed.NULL) continue;
                speedTableLine.put((Bearing)entry.getKey(), boatSpeed);
            }
            mapSpeedTable.put(windSpeed, speedTableLine);
            if (beatAngles.get(index) != null) {
                mapBeatAngles.put(windSpeed, (Bearing)beatAngles.get(index));
            }
            if (jibeAngles.get(index) != null) {
                mapJibeAngles.put(windSpeed, (Bearing)jibeAngles.get(index));
            }
            if (beatSpeed.get(index) != null) {
                mapBeatSOG.put(windSpeed, (Speed)beatSpeed.get(index));
            }
            if (jibeSpeed.get(index) != null) {
                mapJibeSOG.put(windSpeed, (Speed)jibeSpeed.get(index));
            }
            ++index;
        }
        if (mapBeatAngles.size() <= 1 || mapBeatSOG.size() <= 1 || mapJibeAngles.size() <= 1 || mapJibeSOG.size() <= 1) {
            throw new SparseSimulationDataException();
        }
        this.speedTable = mapSpeedTable;
        this.beatAngles = mapBeatAngles;
        this.jibeAngles = mapJibeAngles;
        this.beatSOG = mapBeatSOG;
        this.jibeSOG = mapJibeSOG;
        for (Speed s : this.speedTable.keySet()) {
            if (this.beatAngles.containsKey(s) && !((NavigableMap)this.speedTable.get(s)).containsKey(this.beatAngles.get(s))) {
                ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.beatAngles.get(s), (Speed)this.beatSOG.get(s));
            }
            if (!this.jibeAngles.containsKey(s) || ((NavigableMap)this.speedTable.get(s)).containsKey(this.jibeAngles.get(s))) continue;
            ((NavigableMap)this.speedTable.get(s)).put((Bearing)this.jibeAngles.get(s), (Speed)this.jibeSOG.get(s));
        }
    }

    public double getAvgSpeedInKnots() {
        return this.avgSpeedInKnots;
    }

    private static /* synthetic */ String lambda$1(BoatClass boatClass, Speed speed, Bearing bearing) {
        return "No polar data for boat class " + boatClass.getName() + " for wind speed " + speed + " at true wind angle " + bearing;
    }

    private static /* synthetic */ String lambda$3(BoatClass boatClass, Speed speed, Bearing bearing) {
        return "No polar data for boat class " + boatClass.getName() + " for wind speed " + speed + " at true wind angle " + bearing;
    }
}

