/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.RectangularGrid;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindField;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;

public class PathGeneratorDynProgForward
extends PathGeneratorBase {
    public PathGeneratorDynProgForward(SimulationParameters params) {
        this.parameters = params;
    }

    private DPDuration findMinDur(ArrayList<DPDuration> alldur) {
        DPDuration mindur = alldur.get(0);
        int i = 0;
        while (i < alldur.size()) {
            if (alldur.get((int)i).duration < mindur.duration) {
                mindur = alldur.get(i);
            }
            ++i;
        }
        return mindur;
    }

    private DPDuration calcDuration(TimePoint curtime, int side1, Position p1, Position p2, WindField windField, PolarDiagram polarDiagram) {
        long turnloss = polarDiagram.getTurnLoss();
        TimedPositionImpl currentTimedPosition = new TimedPositionImpl(curtime, p1);
        Wind currentWind = windField.getWind(currentTimedPosition);
        polarDiagram.setWind((SpeedWithBearing)currentWind);
        Bearing bearingToP = p1.getBearingGreatCircle(p2);
        Distance distanceToP = p1.getDistance(p2);
        SpeedWithBearing speedToP = polarDiagram.getSpeedAtBearingOverGround(bearingToP);
        double deltat = speedToP.getMetersPerSecond() <= 0.1 ? 86400.0 : distanceToP.getMeters() / speedToP.getMetersPerSecond();
        long timeToP = curtime.asMillis() + (long)deltat * 1000L;
        Bearing relativeBearing = currentWind.getBearing().reverse().getDifferenceTo(bearingToP);
        int side2 = relativeBearing.getDegrees() == 0.0 ? 0 : (int)Math.signum(relativeBearing.getDegrees());
        if (side1 != 0 && side2 != 0 && side1 == -side2) {
            timeToP += turnloss;
        }
        DPDuration durToP = new DPDuration(timeToP, side2, 0, 0);
        return durToP;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        RectangularGrid boundary = new RectangularGrid(this.parameters.getCourse().get(0), this.parameters.getCourse().get(1));
        WindFieldGenerator windField = this.parameters.getWindField();
        PolarDiagram polarDiagram = this.parameters.getBoatPolarDiagram();
        TimePoint startTime = windField.getStartTime();
        LinkedList<TimedPositionWithSpeed> optPath = new LinkedList<TimedPositionWithSpeed>();
        int spatialGridsizeVertical = 21;
        int spatialGridsizeHorizontal = 138;
        if (spatialGridsizeHorizontal % 2 == 0) {
            ++spatialGridsizeHorizontal;
        }
        Position[][] sailGrid = boundary.generatePositions(spatialGridsizeHorizontal, spatialGridsizeVertical, 0, 0);
        int optimizationGridsizeVertical = spatialGridsizeVertical;
        int optimizationGridsizeHorizontal = spatialGridsizeHorizontal / 2;
        ArrayList paths = new ArrayList();
        ArrayList duras = new ArrayList();
        double mintol = 1.0;
        int maxeqpaths = 2;
        int idxv = 0;
        while (idxv < optimizationGridsizeVertical - 1) {
            ArrayList pathsnew = new ArrayList();
            ArrayList<DPDuration> durasnew = new ArrayList<DPDuration>();
            int range1 = idxv == 0 ? 0 : optimizationGridsizeHorizontal;
            int range2 = idxv == optimizationGridsizeVertical - 2 ? 0 : optimizationGridsizeHorizontal;
            int idxh2 = -range2;
            while (idxh2 <= range2) {
                ArrayList<DPDuration> alldur = new ArrayList<DPDuration>();
                if (idxv > 0) {
                    Vector<DPLocation> tpath;
                    int i;
                    ArrayList tpaths;
                    ArrayList npaths;
                    int j;
                    DPDuration tdur;
                    DPDuration mindur;
                    int idxh1 = -range1;
                    while (idxh1 <= range1) {
                        if (this.isTimedOut()) break;
                        DPDuration durationh1h2 = this.calcDuration((TimePoint)new MillisecondsTimePoint(((DPDuration)duras.get((int)(idxh1 + range1))).duration), ((DPDuration)duras.get((int)(idxh1 + range1))).side, sailGrid[idxv][idxh1 + optimizationGridsizeHorizontal], sailGrid[idxv + 1][idxh2 + optimizationGridsizeHorizontal], windField, polarDiagram);
                        if (durationh1h2.duration >= 0L) {
                            durationh1h2.hidx = idxh1 + range1;
                            alldur.add(durationh1h2);
                        }
                        ++idxh1;
                    }
                    if (idxv != optimizationGridsizeVertical - 2) {
                        mindur = this.findMinDur(alldur);
                        tdur = new DPDuration(mindur.duration, mindur.side, idxh2 + optimizationGridsizeHorizontal, 0);
                        durasnew.add(tdur);
                        int k = 0;
                        j = 0;
                        while (j < alldur.size()) {
                            if (!this.isTimedOut()) {
                                if ((double)alldur.get((int)j).duration <= mintol * (double)mindur.duration && k < maxeqpaths) {
                                    if (pathsnew.size() > 0 && pathsnew.size() == idxh2 + optimizationGridsizeHorizontal + 1) {
                                        npaths = (ArrayList)pathsnew.get(idxh2 + optimizationGridsizeHorizontal);
                                    } else {
                                        npaths = new ArrayList();
                                        pathsnew.add(npaths);
                                    }
                                    tpaths = (ArrayList)paths.get(alldur.get((int)j).hidx);
                                    i = 0;
                                    while (i < tpaths.size()) {
                                        tpath = new Vector((Collection)tpaths.get(i));
                                        tpath.add(new DPLocation(idxh2, mindur.duration));
                                        npaths.add(tpath);
                                        ++i;
                                    }
                                    ++k;
                                }
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else {
                        mindur = this.findMinDur(alldur);
                        tdur = new DPDuration(mindur.duration, mindur.side, 0, 0);
                        durasnew.add(tdur);
                        int k = 0;
                        j = 0;
                        while (j < alldur.size()) {
                            if (!this.isTimedOut()) {
                                if ((double)alldur.get((int)j).duration <= mintol * (double)mindur.duration && k < maxeqpaths) {
                                    if (pathsnew.size() > 0 && pathsnew.size() == idxh2 + range2 + 1) {
                                        npaths = (ArrayList)pathsnew.get(idxh2 + range2);
                                    } else {
                                        npaths = new ArrayList();
                                        pathsnew.add(npaths);
                                    }
                                    tpaths = (ArrayList)paths.get(alldur.get((int)j).hidx);
                                    i = 0;
                                    while (i < tpaths.size()) {
                                        tpath = new Vector<DPLocation>((Collection)tpaths.get(i));
                                        tpath.add(new DPLocation(0, mindur.duration));
                                        npaths.add(tpath);
                                        ++i;
                                    }
                                    ++k;
                                }
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    Vector<DPLocation> tpath = new Vector<DPLocation>();
                    tpath.add(new DPLocation(0, startTime.asMillis()));
                    ArrayList<Vector<DPLocation>> tpaths = new ArrayList<Vector<DPLocation>>();
                    tpaths.add(tpath);
                    pathsnew.add(tpaths);
                    DPDuration tdur = this.calcDuration(startTime, 0, sailGrid[0][optimizationGridsizeHorizontal], sailGrid[1][idxh2 + optimizationGridsizeHorizontal], windField, polarDiagram);
                    tdur.hidx = idxh2 + optimizationGridsizeHorizontal;
                    durasnew.add(tdur);
                    tpath.add(new DPLocation(idxh2, tdur.duration));
                }
                ++idxh2;
            }
            paths = pathsnew;
            duras = durasnew;
            ++idxv;
        }
        if (!this.isTimedOut()) {
            int i = 0;
            while (i < paths.size()) {
                int j = 0;
                while (j < 1) {
                    int k = 0;
                    while (k < ((Vector)((ArrayList)paths.get(i)).get(j)).size()) {
                        Position p = sailGrid[k][((DPLocation)((Vector)((ArrayList)paths.get((int)i)).get((int)j)).get((int)k)).idx + optimizationGridsizeHorizontal];
                        MillisecondsTimePoint t = new MillisecondsTimePoint(((DPLocation)((Vector)((ArrayList)paths.get((int)i)).get((int)j)).get((int)k)).dur);
                        optPath.add(new TimedPositionWithSpeedImpl((TimePoint)t, p, null));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return new PathImpl(optPath, windField, this.algorithmTimedOut);
    }

    class DPDuration {
        long duration;
        int side;
        int hidx;
        int pidx;

        public DPDuration(long dur, int sid, int h, int p) {
            this.duration = dur;
            this.side = sid;
            this.hidx = h;
            this.pidx = p;
        }
    }

    class DPLocation {
        int idx;
        long dur;

        public DPLocation(int i, long d) {
            this.idx = i;
            this.dur = d;
        }
    }
}

