/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class TimestampConverter
extends AbstractDateTimeConverter {
    protected TimestampConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(8) + 1;
        }
        return 8;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(8) + 2;
        }
        return 9;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(value);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putBytesAsTimestamp(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(8) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putLong(0x1000001L, new byte[8], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getPrecision() {
        return 23;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsTimestamp(controller, dataPart, null);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return this.setDate((java.sql.Date)value, null);
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTimestamp(new Timestamp(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Timestamp timestamp = this._getValueAsTimestamp(controller, dataPart, cal);
        return timestamp != null ? new java.sql.Date(timestamp.getTime()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setDate(java.sql.Date value, Calendar cal) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            Calendar calendar;
            if (cal == null) {
                if (this._timeZonePerObject) {
                    this._calLock.lock();
                    calendar = this._cal;
                } else {
                    calendar = (Calendar)_staticCal.get();
                }
            } else {
                calendar = cal;
            }
            byte[] byArray = TimestampConverter._convertMillisecondsToTimestamp(value.getTime(), calendar);
            return byArray;
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Timestamp timestamp = this._getValueAsTimestamp(controller, dataPart, cal);
        if (timestamp == null) {
            return null;
        }
        try {
            Calendar calendar;
            if (cal == null) {
                if (this._timeZonePerObject) {
                    this._calLock.lock();
                    calendar = this._cal;
                } else {
                    calendar = (Calendar)_staticCal.get();
                }
            } else {
                calendar = cal;
            }
            Time time = new Time(TimestampConverter._normalizeTimeMilliseconds(timestamp.getTime(), calendar));
            return time;
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setTime(Time value, Calendar cal) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            Calendar calendar;
            if (cal == null) {
                if (this._timeZonePerObject) {
                    this._calLock.lock();
                    calendar = this._cal;
                } else {
                    calendar = (Calendar)_staticCal.get();
                }
            } else {
                calendar = cal;
            }
            byte[] byArray = TimestampConverter._convertMillisecondsToTimestamp(value.getTime(), calendar);
            return byArray;
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTimestamp(controller, dataPart, cal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            Calendar calendar;
            if (cal == null) {
                if (this._timeZonePerObject) {
                    this._calLock.lock();
                    calendar = this._cal;
                } else {
                    calendar = (Calendar)_staticCal.get();
                }
            } else {
                calendar = cal;
            }
            byte[] byArray = TimestampConverter._convertMillisecondsToTimestamp(value.getTime(), calendar);
            return byArray;
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        Timestamp timestamp = this._getValueAsTimestamp(controller, dataPart, null);
        return timestamp != null ? TimestampConverter._formatTimestamp(this._getValueAsTimestamp(controller, dataPart, null), true) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            Calendar calendar;
            if (this._timeZonePerObject) {
                this._calLock.lock();
                calendar = this._cal;
            } else {
                calendar = (Calendar)_staticCal.get();
            }
            byte[] byArray = TimestampConverter._convertStringToTimestamp(value, calendar);
            return byArray;
        }
        finally {
            if (this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp _getValueAsTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        int offset;
        byte[] buffer;
        byte[] decrypted;
        byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        if (dataPart.isNull(this, controller, decrypted)) {
            return null;
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            buffer = decrypted;
            offset = 0;
        } else {
            buffer = dataPart.getRawPacketArray();
            offset = dataPart.getNonNullDataOffset();
        }
        try {
            Calendar calendar;
            if (cal == null) {
                if (this._timeZonePerObject) {
                    this._calLock.lock();
                    calendar = this._cal;
                } else {
                    calendar = (Calendar)_staticCal.get();
                }
            } else {
                calendar = cal;
            }
            Timestamp timestamp = new Timestamp(TimestampConverter._convertTimestampToMilliseconds(buffer, offset, calendar));
            return timestamp;
        }
        finally {
            if (cal == null && this._timeZonePerObject) {
                this._calLock.unlock();
            }
        }
    }
}

