/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.TableConverter;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.jdbcext.wrapper.CallableStatement;
import com.sap.db.util.HexUtils;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

@ThreadSafe
public abstract class CallableStatementSapDB
extends PreparedStatementSapDB
implements java.sql.CallableStatement {
    public static CallableStatementSapDB getCallableStatementSapDB(java.sql.CallableStatement callableStatement) {
        java.sql.CallableStatement cs = callableStatement;
        while (!(cs instanceof CallableStatementSapDB)) {
            if (cs instanceof CallableStatement) {
                cs = ((CallableStatement)cs).getInner();
                continue;
            }
            return null;
        }
        return (CallableStatementSapDB)cs;
    }

    protected CallableStatementSapDB(Tracer tracer, ConnectionSapDB connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine, StatementSapDB.StatementFlag ... statementFlags) throws SQLException {
        super(tracer, connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, statementFlags);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "wasNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "wasNull", new Object[0]);
            }
            boolean result = this._wasNull();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterIndex);
            }
            if ((result = this._getObject(converter = this._getParameterConverter(parameterIndex))) instanceof AbstractGetval) {
                this._addAppLob((AbstractGetval)result);
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized boolean getBoolean(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            boolean result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte getByte(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            byte result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized short getShort(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            short result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getInt(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            int result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized long getLong(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            long result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized float getFloat(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            float result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized double getDouble(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            double result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex, scale);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            BigDecimal result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Date result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Time result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Timestamp result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            String result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte[] getBytes(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            byte[] result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
            }
            this._registerOutParameter(parameterIndex);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
            }
            this._registerOutParameter(parameterIndex);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterIndex, map);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, Map )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            BigDecimal result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterIndex, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Date result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterIndex, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Time result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterIndex, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Timestamp result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Clob getClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Clob result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Blob getBlob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Blob result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array getArray(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getArray( int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Ref getRef(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRef( int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
            }
            this._registerOutParameter(parameterIndex);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            Object result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterName);
            }
            if ((result = this._getObject(converter = this._getParameterConverter(parameterName))) instanceof AbstractGetval) {
                this._addAppLob((AbstractGetval)result);
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getObject", parameterName, map);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getObject( int, String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean getBoolean(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBoolean", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            boolean result = converter.getBoolean(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte getByte(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getByte", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            byte result = converter.getByte(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            byte by = result;
            return by;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized short getShort(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getShort", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            short result = converter.getShort(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            short s = result;
            return s;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized int getInt(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getInt", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            int result = converter.getInt(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized long getLong(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getLong", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            long result = converter.getLong(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized float getFloat(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getFloat", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            float result = converter.getFloat(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)Float.valueOf(result)));
            }
            float f = result;
            return f;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized double getDouble(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDouble", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            double result = converter.getDouble(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            double d = result;
            return d;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized BigDecimal getBigDecimal(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBigDecimal", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            BigDecimal result = converter.getBigDecimal(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Date result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Date getDate(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getDate", parameterName, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Date result = converter.getDate(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Date date = result;
            return date;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Time result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Time getTime(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTime", parameterName, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Time result = converter.getTime(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Time time = result;
            return time;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Timestamp result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), null);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getTimestamp", parameterName, cal);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Timestamp result = converter.getTimestamp(this, this._getDataPart(converter.getOutputFieldPos()), cal);
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Timestamp timestamp = result;
            return timestamp;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getString", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            String result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized byte[] getBytes(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBytes", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            byte[] result = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)HexUtils.toDisplayHexString(result, 20)));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Clob getClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getClob", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Clob result = converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Clob clob = result;
            return clob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Blob getBlob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getBlob", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Blob result = converter.getBlob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Blob blob = result;
            return blob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Array getArray(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getArray") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getArray", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getArray( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized Ref getRef(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRef") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRef", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRef( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized URL getURL(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getURL( int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized URL getURL(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getURL", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getURL( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType);
            }
            this._setNull(this._getParameterConverter(parameterName).getIndex(), sqlType);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNull") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNull", parameterName, sqlType, typeName);
            }
            this._setNull(this._getParameterConverter(parameterName).getIndex(), sqlType);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(String parameterName, Object x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x));
            }
            this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType);
            }
            this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setObject", parameterName, this._obfuscateEncrypted(parameterName, x), targetSqlType, scale);
            }
            this._setObject(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBoolean(String parameterName, boolean x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBoolean") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBoolean", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBoolean(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setByte(String parameterName, byte x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setByte") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setByte", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setByte(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setShort(String parameterName, short x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setShort") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setShort", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setShort(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setInt(String parameterName, int x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setInt") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setInt", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setInt(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setLong(String parameterName, long x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setLong") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setLong", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setLong(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setFloat(String parameterName, float x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setFloat") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setFloat", parameterName, this._obfuscateEncrypted(parameterName, (Object)Float.valueOf(x)));
            }
            this._setFloat(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDouble(String parameterName, double x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDouble") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDouble", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setDouble(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBigDecimal") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBigDecimal", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBigDecimal(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(String parameterName, Date x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setDate(this._getParameterConverter(parameterName).getIndex(), x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setDate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setDate", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            this._setDate(this._getParameterConverter(parameterName).getIndex(), x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(String parameterName, Time x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setTime(this._getParameterConverter(parameterName).getIndex(), x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTime") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTime", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            this._setTime(this._getParameterConverter(parameterName).getIndex(), x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setTimestamp(this._getParameterConverter(parameterName).getIndex(), x, null);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setTimestamp") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setTimestamp", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), cal);
            }
            this._setTimestamp(this._getParameterConverter(parameterName).getIndex(), x, cal);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setString", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setString(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBytes(String parameterName, byte[] x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBytes") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBytes", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBytes(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setURL(String parameterName, URL x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setURL") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setURL", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setURL( String, URL )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            this._registerOutParameter(parameterName);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
            }
            this._registerOutParameter(parameterName);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
            }
            this._registerOutParameter(parameterName);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getNString(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            String result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized String getNString(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNString", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            String result = converter.getString(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Reader result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getCharacterStream", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Reader result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getNCharacterStream(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            Reader result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized Reader getNCharacterStream(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNCharacterStream", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            Reader result = converter.getCharacterStream(this, this._getDataPart(converter.getOutputFieldPos()));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            Reader reader = result;
            return reader;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized NClob getNClob(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterIndex);
            }
            AbstractConverter converter = this._getParameterConverter(parameterIndex);
            NClob result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized NClob getNClob(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "getNClob", parameterName);
            }
            AbstractConverter converter = this._getParameterConverter(parameterName);
            NClob result = (NClob)converter.getClob(this, this._getDataPart(converter.getOutputFieldPos()));
            this._addAppLob((AbstractGetval)((Object)result));
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, (Object)result));
            }
            NClob nClob = result;
            return nClob;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized RowId getRowId(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized RowId getRowId(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getRowId", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getRowId( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML getSQLXML(int parameterIndex) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterIndex);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized SQLXML getSQLXML(String parameterName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getSQLXML", parameterName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("getSQLXML( String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setNString(String parameterName, String x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNString") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNString", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setString(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setAsciiStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setAsciiStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setAsciiStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNCharacterStream(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNCharacterStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNCharacterStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setCharacterStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBinaryStream") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setBinaryStream(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(String parameterName, Clob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setClob(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setClob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setClob(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(String parameterName, NClob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setNClob(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setNClob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setNClob(String parameterName, Reader x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setNClob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setNClob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setNClob(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(String parameterName, Blob x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBlob(this._getParameterConverter(parameterName).getIndex(), x);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x));
            }
            this._setBlob(this._getParameterConverter(parameterName).getIndex(), x, -1L);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setBlob") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "setBlob", parameterName, this._obfuscateEncrypted(parameterName, (Object)x), length);
            }
            this._setBlob(this._getParameterConverter(parameterName).getIndex(), x, length);
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setRowId(String parameterName, RowId x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setRowId") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setRowId", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setRowId( String, RowId )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setSQLXML") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setSQLXML", parameterName, x);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setSQLXML( String, SQLXML )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterIndex, type);
            }
            if ((result = this._getObject(converter = this._getParameterConverter(parameterIndex), type)) instanceof AbstractGetval) {
                this._addAppLob((AbstractGetval)result);
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "getObject") : null;
        try {
            AbstractConverter converter;
            T result;
            if (on) {
                this._tracer.printCall(this, "getObject", parameterName, type);
            }
            if ((result = this._getObject(converter = this._getParameterConverter(parameterName), type)) instanceof AbstractGetval) {
                this._addAppLob((AbstractGetval)result);
            }
            if (on) {
                this._tracer.printResult(this._obfuscateEncrypted(converter, result));
            }
            T t = result;
            return t;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( String, Object, SQLType )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "setObject") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setObject", parameterName, x, targetSqlType, scaleOrLength);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("setObject( String, Object, SQLType, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, scale);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterIndex, sqlType, typeName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( int, SQLType, String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, scale);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType, int )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        TraceRecord r = pon ? this._newTraceRecord("CallableStatement", "registerOutParameter") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "registerOutParameter", parameterName, sqlType, typeName);
                }
                throw CallableStatementSapDB._getUnsupportedMethodException("registerOutParameter( String, SQLType, String )");
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    private Object _getObject(AbstractConverter converter) throws SQLException {
        if (this._connection.refCursors() && converter instanceof TableConverter && converter.getParameterMode() == ParameterMode.Out) {
            return this._getResultSet(converter);
        }
        return converter.getObject(this, this._getDataPart(converter.getOutputFieldPos()));
    }

    private <T> T _getObject(AbstractConverter converter, Class<T> type) throws SQLException {
        if (this._connection.refCursors() && converter instanceof TableConverter && converter.getParameterMode() == ParameterMode.Out && type == ResultSet.class) {
            return (T)this._getResultSet(converter);
        }
        return converter.getObject(this, this._getDataPart(converter.getOutputFieldPos()), type);
    }

    private ResultSet _getResultSet(AbstractConverter converter) throws SQLException {
        byte[] cursorID = converter.getBytes(this, this._getDataPart(converter.getOutputFieldPos()));
        return this._getTableOutputParametersMap().get(HexUtils.toHexString(cursorID));
    }

    private void _addAppLob(AbstractGetval appLob) {
        if (this._isClosed()) {
            return;
        }
        if (appLob != null) {
            appLob.addAppLob();
        }
    }
}

