/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.usergroup.users;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedUserDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.shared.impl.AbstractUserReference;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.UserGroupListDataProvider;
import com.sap.sse.security.ui.client.component.usergroup.users.UserGroupUserResources;
import com.sap.sse.security.ui.client.component.usergroup.users.UserGroupUsersTableWrapper;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UserGroupDetailPanel
extends Composite
implements SelectionChangeEvent.Handler,
UserGroupListDataProvider.UserGroupListDataProviderChangeHandler {
    private final UserGroupUserResources userGroupUserResources = (UserGroupUserResources)GWT.create(UserGroupUserResources.class);
    private final MultiSelectionModel<UserGroupDTO> userGroupSelectionModel;
    private final UserGroupUsersTableWrapper tenantUsersTable;

    public UserGroupDetailPanel(MultiSelectionModel<UserGroupDTO> refreshableSelectionModel, UserGroupListDataProvider tenantListDataProvider, UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, CellTableWithCheckboxResources tableResources) {
        this.userGroupUserResources.css().ensureInjected();
        refreshableSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)this);
        this.userGroupSelectionModel = refreshableSelectionModel;
        tenantListDataProvider.addChangeHandler((UserGroupListDataProvider.UserGroupListDataProviderChangeHandler)this);
        this.tenantUsersTable = new UserGroupUsersTableWrapper(stringMessages, errorReporter, tableResources, userService, this.userGroupSelectionModel, () -> this.updateUserList());
        VerticalPanel addUserToGroupPanel = new VerticalPanel();
        Widget buttonPanel = this.createButtonPanel(userService, stringMessages);
        this.userGroupSelectionModel.addSelectionChangeHandler(event -> buttonPanel.setVisible(userService.hasPermission((SecuredDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel), (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)));
        addUserToGroupPanel.add(buttonPanel);
        addUserToGroupPanel.add((IsWidget)this.tenantUsersTable);
        this.initWidget((Widget)addUserToGroupPanel);
        this.ensureDebugId(this.getClass().getSimpleName());
    }

    private Widget createButtonPanel(UserService userService, StringMessages stringMessages) {
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredSecurityTypes.USER_GROUP);
        UserManagementWriteServiceAsync userManagementService = userService.getUserManagementWriteService();
        TextBox userBox = new TextBox();
        userBox.addStyleName(this.userGroupUserResources.css().userDefinitionSuggest());
        userBox.getElement().setPropertyString("placeholder", stringMessages.enterUsername());
        userBox.ensureDebugId("UserSuggestion");
        buttonPanel.insertWidgetAtPosition((Widget)userBox, 0);
        Button addButton = buttonPanel.addUpdateAction(stringMessages.addUser(), () -> {
            UserGroupDTO selectedUserGroup;
            String selectedUsername = userBox.getValue();
            if (!this.getSelectedUserGroupUsernames().contains(selectedUsername) && (selectedUserGroup = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel)) != null) {
                userManagementService.addUserToUserGroup(selectedUserGroup.getId().toString(), selectedUsername, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        addButton.ensureDebugId("AddUserButton");
        Button removeButton = buttonPanel.addUpdateAction(stringMessages.actionRemove(), () -> {
            Set selectedUserGroups = this.userGroupSelectionModel.getSelectedSet();
            if (selectedUserGroups != null && selectedUserGroups.size() == 1) {
                UserGroupDTO selectedUserGroup = (UserGroupDTO)selectedUserGroups.iterator().next();
                Set users = ((RefreshableMultiSelectionModel)this.tenantUsersTable.getSelectionModel()).getSelectedSet();
                if (selectedUserGroups == null || selectedUserGroups.isEmpty()) {
                    Window.alert((String)stringMessages.youHaveToSelectAUserGroup());
                    return;
                }
                for (StrippedUserDTO user : users) {
                    String username = user.getName();
                    userManagementService.removeUserFromUserGroup(selectedUserGroup.getId().toString(), username, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        });
        ((RefreshableMultiSelectionModel)this.tenantUsersTable.getSelectionModel()).addSelectionChangeHandler(event -> removeButton.setEnabled(!((RefreshableMultiSelectionModel)this.tenantUsersTable.getSelectionModel()).getSelectedSet().isEmpty()));
        removeButton.setEnabled(false);
        return buttonPanel;
    }

    public void onSelectionChange(SelectionChangeEvent event) {
        this.updateUserList();
    }

    public void updateUserList() {
        this.tenantUsersTable.getFilterPanel().updateAll(this.userGroupSelectionModel.getSelectedSet().isEmpty() || this.userGroupSelectionModel.getSelectedSet().size() > 1 ? Collections.emptySet() : ((UserGroupDTO)this.userGroupSelectionModel.getSelectedSet().iterator().next()).getUsers());
    }

    private List<String> getSelectedUserGroupUsernames() {
        UserGroupDTO tenant = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel);
        List<String> result = tenant != null ? Util.asList((Iterable)tenant.getUsers()).stream().map(AbstractUserReference::getName).collect(Collectors.toList()) : Collections.emptyList();
        return result;
    }

    public void onChange() {
    }
}

