/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The processing guidance for an Firewall Manager rule. This is like a regular rule <a>Statement</a>, but it can only
 * contain a single rule group reference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallManagerStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallManagerStatement.Builder, FirewallManagerStatement> {
    private static final SdkField<ManagedRuleGroupStatement> MANAGED_RULE_GROUP_STATEMENT_FIELD = SdkField
            .<ManagedRuleGroupStatement> builder(MarshallingType.SDK_POJO).memberName("ManagedRuleGroupStatement")
            .getter(getter(FirewallManagerStatement::managedRuleGroupStatement))
            .setter(setter(Builder::managedRuleGroupStatement)).constructor(ManagedRuleGroupStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleGroupStatement").build())
            .build();

    private static final SdkField<RuleGroupReferenceStatement> RULE_GROUP_REFERENCE_STATEMENT_FIELD = SdkField
            .<RuleGroupReferenceStatement> builder(MarshallingType.SDK_POJO)
            .memberName("RuleGroupReferenceStatement")
            .getter(getter(FirewallManagerStatement::ruleGroupReferenceStatement))
            .setter(setter(Builder::ruleGroupReferenceStatement))
            .constructor(RuleGroupReferenceStatement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupReferenceStatement")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANAGED_RULE_GROUP_STATEMENT_FIELD, RULE_GROUP_REFERENCE_STATEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ManagedRuleGroupStatement managedRuleGroupStatement;

    private final RuleGroupReferenceStatement ruleGroupReferenceStatement;

    private FirewallManagerStatement(BuilderImpl builder) {
        this.managedRuleGroupStatement = builder.managedRuleGroupStatement;
        this.ruleGroupReferenceStatement = builder.ruleGroupReferenceStatement;
    }

    /**
     * <p>
     * A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This is managed
     * by Firewall Manager for an Firewall Manager WAF policy.
     * </p>
     * 
     * @return A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This is
     *         managed by Firewall Manager for an Firewall Manager WAF policy.
     */
    public final ManagedRuleGroupStatement managedRuleGroupStatement() {
        return managedRuleGroupStatement;
    }

    /**
     * <p>
     * A statement used by Firewall Manager to run the rules that are defined in a rule group. This is managed by
     * Firewall Manager for an Firewall Manager WAF policy.
     * </p>
     * 
     * @return A statement used by Firewall Manager to run the rules that are defined in a rule group. This is managed
     *         by Firewall Manager for an Firewall Manager WAF policy.
     */
    public final RuleGroupReferenceStatement ruleGroupReferenceStatement() {
        return ruleGroupReferenceStatement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managedRuleGroupStatement());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupReferenceStatement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallManagerStatement)) {
            return false;
        }
        FirewallManagerStatement other = (FirewallManagerStatement) obj;
        return Objects.equals(managedRuleGroupStatement(), other.managedRuleGroupStatement())
                && Objects.equals(ruleGroupReferenceStatement(), other.ruleGroupReferenceStatement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallManagerStatement").add("ManagedRuleGroupStatement", managedRuleGroupStatement())
                .add("RuleGroupReferenceStatement", ruleGroupReferenceStatement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedRuleGroupStatement":
            return Optional.ofNullable(clazz.cast(managedRuleGroupStatement()));
        case "RuleGroupReferenceStatement":
            return Optional.ofNullable(clazz.cast(ruleGroupReferenceStatement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ManagedRuleGroupStatement", MANAGED_RULE_GROUP_STATEMENT_FIELD);
        map.put("RuleGroupReferenceStatement", RULE_GROUP_REFERENCE_STATEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FirewallManagerStatement, T> g) {
        return obj -> g.apply((FirewallManagerStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallManagerStatement> {
        /**
         * <p>
         * A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This is
         * managed by Firewall Manager for an Firewall Manager WAF policy.
         * </p>
         * 
         * @param managedRuleGroupStatement
         *        A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This
         *        is managed by Firewall Manager for an Firewall Manager WAF policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement);

        /**
         * <p>
         * A statement used by Firewall Manager to run the rules that are defined in a managed rule group. This is
         * managed by Firewall Manager for an Firewall Manager WAF policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedRuleGroupStatement.Builder}
         * avoiding the need to create one manually via {@link ManagedRuleGroupStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedRuleGroupStatement.Builder#build()} is called immediately
         * and its result is passed to {@link #managedRuleGroupStatement(ManagedRuleGroupStatement)}.
         * 
         * @param managedRuleGroupStatement
         *        a consumer that will call methods on {@link ManagedRuleGroupStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedRuleGroupStatement(ManagedRuleGroupStatement)
         */
        default Builder managedRuleGroupStatement(Consumer<ManagedRuleGroupStatement.Builder> managedRuleGroupStatement) {
            return managedRuleGroupStatement(ManagedRuleGroupStatement.builder().applyMutation(managedRuleGroupStatement).build());
        }

        /**
         * <p>
         * A statement used by Firewall Manager to run the rules that are defined in a rule group. This is managed by
         * Firewall Manager for an Firewall Manager WAF policy.
         * </p>
         * 
         * @param ruleGroupReferenceStatement
         *        A statement used by Firewall Manager to run the rules that are defined in a rule group. This is
         *        managed by Firewall Manager for an Firewall Manager WAF policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement);

        /**
         * <p>
         * A statement used by Firewall Manager to run the rules that are defined in a rule group. This is managed by
         * Firewall Manager for an Firewall Manager WAF policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleGroupReferenceStatement.Builder}
         * avoiding the need to create one manually via {@link RuleGroupReferenceStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupReferenceStatement.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleGroupReferenceStatement(RuleGroupReferenceStatement)}.
         * 
         * @param ruleGroupReferenceStatement
         *        a consumer that will call methods on {@link RuleGroupReferenceStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroupReferenceStatement(RuleGroupReferenceStatement)
         */
        default Builder ruleGroupReferenceStatement(Consumer<RuleGroupReferenceStatement.Builder> ruleGroupReferenceStatement) {
            return ruleGroupReferenceStatement(RuleGroupReferenceStatement.builder().applyMutation(ruleGroupReferenceStatement)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ManagedRuleGroupStatement managedRuleGroupStatement;

        private RuleGroupReferenceStatement ruleGroupReferenceStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallManagerStatement model) {
            managedRuleGroupStatement(model.managedRuleGroupStatement);
            ruleGroupReferenceStatement(model.ruleGroupReferenceStatement);
        }

        public final ManagedRuleGroupStatement.Builder getManagedRuleGroupStatement() {
            return managedRuleGroupStatement != null ? managedRuleGroupStatement.toBuilder() : null;
        }

        public final void setManagedRuleGroupStatement(ManagedRuleGroupStatement.BuilderImpl managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement != null ? managedRuleGroupStatement.build() : null;
        }

        @Override
        public final Builder managedRuleGroupStatement(ManagedRuleGroupStatement managedRuleGroupStatement) {
            this.managedRuleGroupStatement = managedRuleGroupStatement;
            return this;
        }

        public final RuleGroupReferenceStatement.Builder getRuleGroupReferenceStatement() {
            return ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.toBuilder() : null;
        }

        public final void setRuleGroupReferenceStatement(RuleGroupReferenceStatement.BuilderImpl ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement != null ? ruleGroupReferenceStatement.build() : null;
        }

        @Override
        public final Builder ruleGroupReferenceStatement(RuleGroupReferenceStatement ruleGroupReferenceStatement) {
            this.ruleGroupReferenceStatement = ruleGroupReferenceStatement;
            return this;
        }

        @Override
        public FirewallManagerStatement build() {
            return new FirewallManagerStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
