/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class EvalDecisionDetailsTypeCopier {
    static Map<String, String> copy(Map<String, String> evalDecisionDetailsTypeParam) {
        Map<String, String> map;
        if (evalDecisionDetailsTypeParam == null || evalDecisionDetailsTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(evalDecisionDetailsTypeParam.size());
            evalDecisionDetailsTypeParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, String> copyEnumToString(Map<String, PolicyEvaluationDecisionType> evalDecisionDetailsTypeParam) {
        Map<String, String> map;
        if (evalDecisionDetailsTypeParam == null || evalDecisionDetailsTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, String> modifiableMap = new LinkedHashMap<>(evalDecisionDetailsTypeParam.size());
            evalDecisionDetailsTypeParam.forEach((key, value) -> {
                String result = value.toString();
                modifiableMap.put(key, result);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, PolicyEvaluationDecisionType> copyStringToEnum(Map<String, String> evalDecisionDetailsTypeParam) {
        Map<String, PolicyEvaluationDecisionType> map;
        if (evalDecisionDetailsTypeParam == null || evalDecisionDetailsTypeParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, PolicyEvaluationDecisionType> modifiableMap = new LinkedHashMap<>(evalDecisionDetailsTypeParam.size());
            evalDecisionDetailsTypeParam.forEach((key, value) -> {
                PolicyEvaluationDecisionType result = PolicyEvaluationDecisionType.fromValue(value);
                modifiableMap.put(key, result);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
