/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.orchestration.CreateLoadBalancerMapping;
import com.sap.sse.landscape.orchestration.Procedure;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.IntStream;

public class CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends CreateLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>
implements Procedure<ShardingKey> {
    private final boolean forceDNSUpdate;

    public static <ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, BuilderT extends Builder<BuilderT, CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>> Builder<BuilderT, CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> builder() {
        return new BuilderImpl();
    }

    protected CreateDNSBasedLoadBalancerMapping(BuilderImpl<?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
        this.forceDNSUpdate = builder.isForceDNSUpdate();
    }

    @Override
    public void run() throws JSchException, IOException, InterruptedException, SftpException {
        super.run();
        this.createRoute53Mapping();
    }

    private void createRoute53Mapping() {
        String hostname = this.getHostName();
        ApplicationLoadBalancer alb = this.getLoadBalancerUsed();
        this.getLandscape().setDNSRecordToApplicationLoadBalancer(this.getLandscape().getDNSHostedZoneId(AwsLandscape.getHostedZoneName(hostname)), hostname, alb, this.forceDNSUpdate);
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends CreateLoadBalancerMapping.Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT> {
        public BuilderT forceDNSUpdate(boolean var1);
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends CreateLoadBalancerMapping.BuilderImpl<BuilderT, CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT>
    implements Builder<BuilderT, CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT, ProcessT> {
        private static final Logger logger = Logger.getLogger(BuilderImpl.class.getName());
        private boolean forceDNSUpdate;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT forceDNSUpdate(boolean forceDNSUpdate) {
            this.forceDNSUpdate = forceDNSUpdate;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public ApplicationLoadBalancer<ShardingKey> getLoadBalancerUsed() throws InterruptedException, ExecutionException {
            ApplicationLoadBalancer result = super.getLoadBalancerUsed() != null ? super.getLoadBalancerUsed() : this.getOrCreateDNSMappedLoadBalancer((AwsLandscape<ShardingKey>)this.getLandscape(), this.getProcess().getHost().getRegion(), this.getSecurityGroupForVpc());
            return result;
        }

        private ApplicationLoadBalancer<ShardingKey> getOrCreateDNSMappedLoadBalancer(AwsLandscape<ShardingKey> landscape, Region region, SecurityGroup securityGroupForVpc) throws InterruptedException, ExecutionException {
            ApplicationLoadBalancer<ShardingKey> result = null;
            HashSet<String> loadBalancerNames = new HashSet<String>();
            for (ApplicationLoadBalancer<ShardingKey> loadBalancer : landscape.getLoadBalancers(region)) {
                if (!ApplicationLoadBalancer.ALB_NAME_PATTERN.matcher(loadBalancer.getName()).matches()) continue;
                loadBalancerNames.add(loadBalancer.getName());
                if (Util.size(loadBalancer.getRules()) > 95) continue;
                result = loadBalancer;
                break;
            }
            if (result == null) {
                String newLoadBalancerName = this.getAvailableDNSMappedAlbName(loadBalancerNames);
                logger.info("Creating DNS-mapped application load balancer " + newLoadBalancerName);
                result = landscape.createLoadBalancer(newLoadBalancerName, region, securityGroupForVpc);
                this.waitUntilLoadBalancerProvisioned(landscape, result);
            }
            return result;
        }

        private String getAvailableDNSMappedAlbName(Set<String> loadBalancerNames) {
            HashSet<Integer> numbersTaken = new HashSet<Integer>();
            for (String loadBalancerName : loadBalancerNames) {
                Matcher matcher = ApplicationLoadBalancer.ALB_NAME_PATTERN.matcher(loadBalancerName);
                if (!matcher.find()) continue;
                numbersTaken.add(Integer.parseInt(matcher.group(1)));
            }
            return "DNSMapped-" + IntStream.range(0, 20).filter(i -> !numbersTaken.contains(i)).min().getAsInt();
        }

        public CreateDNSBasedLoadBalancerMapping<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            return new CreateDNSBasedLoadBalancerMapping(this);
        }

        boolean isForceDNSUpdate() {
            return this.forceDNSUpdate;
        }
    }
}

