/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl.dto;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModifiableStatisticQueryDefinitionDTO
implements StatisticQueryDefinitionDTO {
    private static final Logger logger = Logger.getLogger(ModifiableStatisticQueryDefinitionDTO.class.getName());
    private static final long serialVersionUID = -6438771277564908352L;
    private FunctionDTO statisticToCalculate;
    private AggregationProcessorDefinitionDTO aggregatorDefinition;
    private ArrayList<FunctionDTO> dimensionsToGroupBy;
    private DataRetrieverChainDefinitionDTO dataRetrieverChainDefinition;
    private HashMap<DataRetrieverLevelDTO, SerializableSettings> retrieverSettings;
    private HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelection;
    private String localeInfoName;
    private transient boolean queryChangedSinceLastRun;

    @Deprecated
    ModifiableStatisticQueryDefinitionDTO() {
    }

    public ModifiableStatisticQueryDefinitionDTO(String localeInfoName, FunctionDTO statisticToCalculate, AggregationProcessorDefinitionDTO aggregatorDefinition, DataRetrieverChainDefinitionDTO dataRetrieverChainDefinition) {
        this.localeInfoName = localeInfoName;
        this.statisticToCalculate = statisticToCalculate;
        this.aggregatorDefinition = aggregatorDefinition;
        this.dataRetrieverChainDefinition = dataRetrieverChainDefinition;
        this.retrieverSettings = new HashMap();
        this.filterSelection = new HashMap();
        this.dimensionsToGroupBy = new ArrayList();
    }

    public ModifiableStatisticQueryDefinitionDTO(StatisticQueryDefinitionDTO definition) {
        this.localeInfoName = definition.getLocaleInfoName();
        this.statisticToCalculate = definition.getStatisticToCalculate();
        this.aggregatorDefinition = definition.getAggregatorDefinition();
        this.dataRetrieverChainDefinition = definition.getDataRetrieverChainDefinition();
        this.retrieverSettings = new HashMap<DataRetrieverLevelDTO, SerializableSettings>(definition.getRetrieverSettings());
        this.dimensionsToGroupBy = new ArrayList<FunctionDTO>(definition.getDimensionsToGroupBy());
        this.filterSelection = new HashMap();
        HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelectionToCopy = definition.getFilterSelection();
        for (DataRetrieverLevelDTO retrieverLevel : filterSelectionToCopy.keySet()) {
            this.filterSelection.put(retrieverLevel, new HashMap(filterSelectionToCopy.get(retrieverLevel)));
        }
    }

    @Override
    public DataRetrieverChainDefinitionDTO getDataRetrieverChainDefinition() {
        return this.dataRetrieverChainDefinition;
    }

    public void setDataRetrieverChainDefinition(DataRetrieverChainDefinitionDTO dataRetrieverChainDefinition) {
        if (dataRetrieverChainDefinition == null) {
            throw new NullPointerException("The data retriever chain definition mustn't be null");
        }
        this.dataRetrieverChainDefinition = dataRetrieverChainDefinition;
    }

    @Override
    public HashMap<DataRetrieverLevelDTO, SerializableSettings> getRetrieverSettings() {
        return this.retrieverSettings;
    }

    public void setRetrieverSettings(DataRetrieverLevelDTO retrieverLevel, SerializableSettings settings) {
        if (retrieverLevel == null) {
            throw new NullPointerException("The retriever level mustn't be null");
        }
        this.retrieverSettings.put(retrieverLevel, settings);
    }

    @Override
    public HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> getFilterSelection() {
        return new HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>>(this.filterSelection);
    }

    public void setFilterSelectionFor(DataRetrieverLevelDTO retrieverLevel, HashMap<FunctionDTO, HashSet<? extends Serializable>> levelFilterSelection) {
        if (retrieverLevel == null) {
            throw new NullPointerException("The retriever level mustn't be null");
        }
        if (levelFilterSelection == null) {
            throw new NullPointerException("The level filter selection mustn't be null");
        }
        this.filterSelection.put(retrieverLevel, levelFilterSelection);
    }

    @Override
    public ArrayList<FunctionDTO> getDimensionsToGroupBy() {
        return this.dimensionsToGroupBy;
    }

    public void appendDimensionToGroupBy(FunctionDTO dimensionToGroupBy) {
        if (dimensionToGroupBy == null) {
            throw new NullPointerException("The dimension mustn't be null");
        }
        this.dimensionsToGroupBy.add(dimensionToGroupBy);
    }

    @Override
    public FunctionDTO getStatisticToCalculate() {
        return this.statisticToCalculate;
    }

    public void setStatisticToCalculate(FunctionDTO statisticToCalculate) {
        if (statisticToCalculate == null) {
            throw new NullPointerException("The statistic to calculate mustn't be null");
        }
        this.statisticToCalculate = statisticToCalculate;
    }

    @Override
    public AggregationProcessorDefinitionDTO getAggregatorDefinition() {
        return this.aggregatorDefinition;
    }

    public void setAggregatorDefinition(AggregationProcessorDefinitionDTO aggregatorDefinition) {
        if (aggregatorDefinition == null) {
            throw new NullPointerException("The aggregator definition mustn't be null");
        }
        this.aggregatorDefinition = aggregatorDefinition;
    }

    @Override
    public String getLocaleInfoName() {
        return this.localeInfoName;
    }

    public void setLocaleInfoName(String localeInfoName) {
        if (localeInfoName == null) {
            throw new NullPointerException("The locale info name mustn't be null");
        }
        this.localeInfoName = localeInfoName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregatorDefinition == null ? 0 : this.aggregatorDefinition.hashCode());
        result = 31 * result + (this.dataRetrieverChainDefinition == null ? 0 : this.dataRetrieverChainDefinition.hashCode());
        result = 31 * result + (this.dimensionsToGroupBy == null ? 0 : this.dimensionsToGroupBy.hashCode());
        result = 31 * result + (this.filterSelection == null ? 0 : this.filterSelection.hashCode());
        result = 31 * result + (this.retrieverSettings == null ? 0 : this.retrieverSettings.hashCode());
        result = 31 * result + (this.statisticToCalculate == null ? 0 : this.statisticToCalculate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifiableStatisticQueryDefinitionDTO other = (ModifiableStatisticQueryDefinitionDTO)obj;
        if (this.aggregatorDefinition == null ? other.aggregatorDefinition != null : !this.aggregatorDefinition.equals(other.aggregatorDefinition)) {
            return false;
        }
        if (this.dataRetrieverChainDefinition == null ? other.dataRetrieverChainDefinition != null : !this.dataRetrieverChainDefinition.equals(other.dataRetrieverChainDefinition)) {
            return false;
        }
        if (this.dimensionsToGroupBy == null ? other.dimensionsToGroupBy != null : !this.dimensionsToGroupBy.equals(other.dimensionsToGroupBy)) {
            return false;
        }
        if (this.filterSelection == null ? other.filterSelection != null : !this.filterSelection.equals(other.filterSelection)) {
            return false;
        }
        if (this.retrieverSettings == null ? other.retrieverSettings != null : !this.retrieverSettings.equals(other.retrieverSettings)) {
            return false;
        }
        return !(this.statisticToCalculate == null ? other.statisticToCalculate != null : !this.statisticToCalculate.equals(other.statisticToCalculate));
    }

    @Override
    public void setQueryChangedSinceLastRun(boolean queryChangedSinceLastRun) {
        this.queryChangedSinceLastRun = queryChangedSinceLastRun;
    }

    @Override
    public boolean isQueryChangedSinceLastRun() {
        return this.queryChangedSinceLastRun;
    }

    public String toString() {
        try {
            return String.valueOf(this.getAggregatorDefinition().toString()) + " over " + this.getStatisticToCalculate() + ", grouped by " + this.getDimensionsToGroupBy() + " and filtered by " + this.getFilterSelection();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception trying to stringify a data mining query", e);
            return "<exception in query's toString() method: " + e.getMessage() + ">";
        }
    }
}

