/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl.dto;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DataRetrieverChainDefinitionDTO
implements Serializable,
Comparable<DataRetrieverChainDefinitionDTO> {
    private static final long serialVersionUID = 7806173601799997214L;
    private String dataSourceTypeName;
    private ArrayList<DataRetrieverLevelDTO> retrieverLevels;
    private String displayName;

    @Deprecated
    DataRetrieverChainDefinitionDTO() {
    }

    public DataRetrieverChainDefinitionDTO(String name, String dataSourceTypeName, ArrayList<DataRetrieverLevelDTO> retrieverLevels) {
        this.displayName = name;
        this.dataSourceTypeName = dataSourceTypeName;
        this.retrieverLevels = new ArrayList<DataRetrieverLevelDTO>(retrieverLevels);
    }

    public String getName() {
        return this.displayName;
    }

    public String getDataSourceTypeName() {
        return this.dataSourceTypeName;
    }

    public String getRetrievedDataTypeName() {
        return this.retrieverLevels.get(this.retrieverLevels.size() - 1).getRetrievedDataType().getTypeName();
    }

    public ArrayList<DataRetrieverLevelDTO> getRetrieverLevels() {
        return this.retrieverLevels;
    }

    public int getLevelAmount() {
        return this.retrieverLevels.size();
    }

    public DataRetrieverLevelDTO getRetrieverLevel(int levelIndex) {
        if (levelIndex < 0 || levelIndex >= this.getLevelAmount()) {
            return null;
        }
        return this.retrieverLevels.get(levelIndex);
    }

    public DataRetrieverLevelDTO getNextRetrieverLevel(DataRetrieverLevelDTO retrieverLevel) {
        return this.getRetrieverLevel(retrieverLevel.getLevel() + 1);
    }

    public DataRetrieverLevelDTO getPreviousRetrieverLevel(DataRetrieverLevelDTO retrieverLevel) {
        return this.getRetrieverLevel(retrieverLevel.getLevel() - 1);
    }

    public boolean hasSettings() {
        for (DataRetrieverLevelDTO retrieverLevel : this.retrieverLevels) {
            if (!retrieverLevel.hasSettings()) continue;
            return true;
        }
        return false;
    }

    public HashMap<DataRetrieverLevelDTO, SerializableSettings> getDefaultSettings() {
        HashMap<DataRetrieverLevelDTO, SerializableSettings> settings = new HashMap<DataRetrieverLevelDTO, SerializableSettings>();
        for (DataRetrieverLevelDTO retrieverLevel : this.retrieverLevels) {
            if (!retrieverLevel.hasSettings()) continue;
            settings.put(retrieverLevel, retrieverLevel.getDefaultSettings());
        }
        return settings;
    }

    @Override
    public int compareTo(DataRetrieverChainDefinitionDTO other) {
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.valueOf(this.getDataSourceTypeName()) + " -> " + this.getRetrievedDataTypeName() + "[name: " + this.displayName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceTypeName == null ? 0 : this.dataSourceTypeName.hashCode());
        result = 31 * result + (this.retrieverLevels == null ? 0 : this.retrieverLevels.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRetrieverChainDefinitionDTO other = (DataRetrieverChainDefinitionDTO)obj;
        if (this.dataSourceTypeName == null ? other.dataSourceTypeName != null : !this.dataSourceTypeName.equals(other.dataSourceTypeName)) {
            return false;
        }
        return !(this.retrieverLevels == null ? other.retrieverLevels != null : !this.retrieverLevels.equals(other.retrieverLevels));
    }
}

