/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.xdstorage.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.json.client.JSONObject;
import com.sap.sse.gwt.client.messaging.MessageEvent;
import com.sap.sse.gwt.client.messaging.MessagePort;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorageEvent;
import com.sap.sse.gwt.client.xdstorage.impl.CrossDomainStorageEventImpl;
import com.sap.sse.gwt.client.xdstorage.impl.LocalStorageDrivenByMessageEvents;
import com.sap.sse.gwt.client.xdstorage.impl.Response;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;

public class CrossDomainStorageImpl
implements CrossDomainStorage {
    private final MessagePort portToStorageMessagingEntryPoint;
    private final Map<UUID, Consumer<Object>> resultForwardersByRequestUuidAsString = new HashMap<UUID, Consumer<Object>>();
    private final String targetOrigin;
    private final Set<CrossDomainStorageEvent.Handler> storageEventHandlers = new HashSet<CrossDomainStorageEvent.Handler>();
    private boolean registeredAsStorageEventListener;

    public CrossDomainStorageImpl(MessagePort portToStorageMessagingEntryPoint, String targetOrigin) {
        this.targetOrigin = targetOrigin;
        this.portToStorageMessagingEntryPoint = portToStorageMessagingEntryPoint;
        portToStorageMessagingEntryPoint.addResponseListener(messageEvent -> this.dispatchMessageToCallback(messageEvent));
    }

    private void postMessageAndRegisterCallback(UUID id, JSONObject request, Consumer<Object> resultConsumer) {
        this.resultForwardersByRequestUuidAsString.put(id, resultConsumer);
        this.portToStorageMessagingEntryPoint.postMessage(request.getJavaScriptObject(), this.getTargetOrigin());
    }

    private void dispatchMessageToCallback(MessageEvent<JavaScriptObject> messageEvent) {
        Response response = (Response)messageEvent.getData().cast();
        UUID idOfRequestToWhichThisIsTheResponse = LocalStorageDrivenByMessageEvents.getId(response);
        if (idOfRequestToWhichThisIsTheResponse == null) {
            CrossDomainStorageEventImpl storageEvent = new CrossDomainStorageEventImpl(response.getKey(), response.getNewValue(), response.getOldValue(), response.getUrl());
            GWT.log((String)("Received cross-domain storage event " + storageEvent + "; sending to " + this.storageEventHandlers.size() + " registered handlers"));
            for (CrossDomainStorageEvent.Handler storageEventHandler : this.storageEventHandlers) {
                storageEventHandler.onStorageChange(storageEvent);
            }
        } else {
            Consumer<Object> resultForwarder = this.resultForwardersByRequestUuidAsString.remove(idOfRequestToWhichThisIsTheResponse);
            if (resultForwarder != null) {
                resultForwarder.accept(response.getResult());
            }
        }
    }

    private String getTargetOrigin() {
        return this.targetOrigin;
    }

    @Override
    public HandlerRegistration addStorageEventHandler(CrossDomainStorageEvent.Handler handler) {
        this.storageEventHandlers.add(handler);
        if (!this.registeredAsStorageEventListener) {
            this.registeredAsStorageEventListener = true;
            UUID id = UUID.randomUUID();
            this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createRegisterStorageEventListener(id), null);
        }
        return () -> {
            boolean bl = this.storageEventHandlers.remove(handler);
        };
    }

    @Override
    public void setItem(String key, String value, Consumer<Void> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createSetItemRequest(id, key, value), result -> {
            if (callback != null) {
                callback.accept(null);
            }
        });
    }

    @Override
    public void getItem(String key, Consumer<String> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createGetItemRequest(id, key), result -> {
            if (callback != null) {
                callback.accept((String)result);
            }
        });
    }

    @Override
    public void removeItem(String key, Consumer<Void> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createRemoveItemRequest(id, key), result -> {
            if (callback != null) {
                callback.accept(null);
            }
        });
    }

    @Override
    public void clear(Consumer<Void> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createClearRequest(id), result -> {
            if (callback != null) {
                callback.accept(null);
            }
        });
    }

    @Override
    public void key(int index, Consumer<String> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createKeyRequest(id, index), result -> {
            if (callback != null) {
                callback.accept((String)result);
            }
        });
    }

    @Override
    public void getLength(Consumer<Integer> callback) {
        UUID id = UUID.randomUUID();
        this.postMessageAndRegisterCallback(id, LocalStorageDrivenByMessageEvents.createGetLengthRequest(id), result -> {
            if (callback != null) {
                callback.accept(((Number)result).intValue());
            }
        });
    }
}

