/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import java.util.function.Consumer;

public class NotificationPanel {
    private static final int NOTIFICATION_TIME = 10000;
    private static final double FADE_OUT_PERCENT = 0.98;
    private static final double FADE_IN_PERCENT = 0.005;
    private final String message;
    private final Panel panel;
    private final Panel parent;
    private final Animation animation;
    private boolean alreadyShown = false;
    private HandlerRegistration registration;
    private static CrossDomainStorage storage;

    public NotificationPanel(String message, Notification.NotificationType type, Panel parent) {
        this.message = message;
        this.parent = parent;
        this.panel = new FlowPanel();
        this.panel.addStyleName(Notification.ress.css().notification());
        this.panel.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.panel.getElement().getStyle().setColor(type.getColor());
        this.panel.getElement().getStyle().setBackgroundColor(type.getBackgroundColor());
        this.panel.getElement().setInnerText(String.valueOf(type.getDecorator()) + " " + message);
        this.registration = Event.addNativePreviewHandler((Event.NativePreviewHandler)new Event.NativePreviewHandler(){

            public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                Element target = Element.as((JavaScriptObject)event.getNativeEvent().getEventTarget());
                if (event.getTypeInt() == 1 && target == NotificationPanel.this.panel.getElement()) {
                    NotificationPanel.this.animation.cancel();
                }
            }
        });
        this.animation = new Animation(){

            protected void onStart() {
                super.onStart();
                NotificationPanel.this.alreadyShown = true;
                NotificationPanel.this.panel.getElement().getStyle().setOpacity(0.0);
            }

            protected void onUpdate(double progress) {
                if (progress < 0.005) {
                    double relPr = progress / 0.005;
                    NotificationPanel.this.panel.getElement().getStyle().setOpacity(relPr);
                } else if (progress > 0.98) {
                    double relPr = (progress - 0.98) / 0.020000000000000018;
                    NotificationPanel.this.panel.getElement().getStyle().setOpacity(1.0 - relPr);
                } else {
                    NotificationPanel.this.panel.getElement().getStyle().clearOpacity();
                }
            }

            protected void onComplete() {
                NotificationPanel.this.remove();
            }

            protected void onCancel() {
                NotificationPanel.this.remove();
            }
        };
    }

    public static void setStorage(CrossDomainStorage storage) {
        NotificationPanel.storage = storage;
    }

    public void show() {
        Consumer<Integer> showAnimationWithTimeout = timeout -> {
            if (!this.animation.isRunning()) {
                this.parent.add((Widget)this.panel);
                this.animation.run(timeout.intValue());
            }
        };
        if (storage != null) {
            storage.getItem("sse.notification.customTimeOutInSeconds", customTimeOut -> {
                if (customTimeOut != null && !customTimeOut.isEmpty()) {
                    int timeout;
                    try {
                        timeout = Integer.parseInt(customTimeOut) * 1000;
                    }
                    catch (Exception e) {
                        timeout = 10000;
                    }
                    showAnimationWithTimeout.accept(timeout);
                }
            });
        } else {
            showAnimationWithTimeout.accept(10000);
        }
    }

    public boolean alreadyShown() {
        return this.alreadyShown;
    }

    public void remove() {
        this.registration.removeHandler();
        this.parent.remove((Widget)this.panel);
        Notification.checkQueue(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationPanel other = (NotificationPanel)obj;
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

