/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Team;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.NationalityImpl;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.NationalityJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.PersonJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TeamJsonSerializer;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.UpdateCompetitor;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.RGBColor;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.OperationFailedException;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.shared.json.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/v1/competitors")
public class CompetitorsResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(CompetitorsResource.class.getName());
    private static final int MAX_SIZE_IN_MB = 5;

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{competitorId}")
    public Response getCompetitor(@PathParam(value="competitorId") String competitorIdAsString, @QueryParam(value="secret") String secret, @QueryParam(value="leaderboardName") String leaderboardName) {
        Response response;
        DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorIdAsString);
        if (competitor == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a competitor with id '" + StringEscapeUtils.escapeHtml((String)competitorIdAsString) + "'.")).type("text/plain").build();
        } else {
            boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, secret);
            boolean competitorInRegatta = false;
            if (skip) {
                Regatta regatta = this.getService().getRegattaByName(leaderboardName);
                competitorInRegatta = Util.contains((Iterable)regatta.getAllCompetitors(), (Object)competitor);
            }
            if (!skip || !competitorInRegatta) {
                this.getSecurityService().checkCurrentUserHasOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS);
            }
            response = Response.ok((Object)this.streamingOutput(CompetitorJsonSerializer.create().serialize((Competitor)competitor))).build();
        }
        return response;
    }

    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{competitorId}")
    public Response updateCompetitor(@PathParam(value="competitorId") String competitorIdAsString, String json) {
        Response response;
        Object competitorObject;
        if (json == null || json.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing competitor data.").type("text/plain").build();
        }
        try {
            competitorObject = new JSONParser().parse(json);
            if (competitorObject == null || !(competitorObject instanceof JSONObject)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException | ParseException pe) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Competitor data is required to be given as json object").type("text/plain").build();
        }
        JSONObject competitorJson = (JSONObject)competitorObject;
        DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorIdAsString);
        if (competitor == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a competitor with id '" + StringEscapeUtils.escapeHtml((String)competitorIdAsString) + "'.")).type("text/plain").build();
        } else if (this.getSecurityService().hasCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)competitor)) {
            Duration duration;
            Double timeOnTimeFactor;
            Nationality nationality;
            URI teamImageUri;
            URI flagImageUri;
            Color color;
            try {
                color = competitorJson.containsKey((Object)"displayColor") ? this.createColorFromString((String)competitorJson.get((Object)"displayColor")) : competitor.getColor();
            }
            catch (IllegalArgumentException iae) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid color %s", iae.getMessage())).type("text/plain").build();
            }
            try {
                flagImageUri = competitorJson.containsKey((Object)"flagImageUri") ? this.createURIFromString((String)competitorJson.get((Object)"flagImageUri")) : competitor.getFlagImage();
            }
            catch (URISyntaxException use) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid %s %s", "flagImageUri", competitorJson.get((Object)"flagImageUri"))).type("text/plain").build();
            }
            try {
                teamImageUri = competitorJson.containsKey((Object)"teamImageUri") ? this.createURIFromString((String)competitorJson.get((Object)"teamImageUri")) : (competitor.getTeam() != null ? competitor.getTeam().getImage() : null);
            }
            catch (URISyntaxException use) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid %s %s", "teamImageUri", competitorJson.get((Object)"teamImageUri"))).type("text/plain").build();
            }
            try {
                nationality = competitorJson.containsKey((Object)"nationality") ? this.createNationalityFromString((String)competitorJson.get((Object)"nationality")) : competitor.getNationality();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid %s %s", "nationality", competitorJson.get((Object)"nationality"))).type("text/plain").build();
            }
            try {
                timeOnTimeFactor = competitorJson.containsKey((Object)"timeOnTimeFactor") ? this.createDoubleFromObject(competitorJson.get((Object)"timeOnTimeFactor")) : competitor.getTimeOnTimeFactor();
            }
            catch (IllegalArgumentException iae) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid %s %s", "timeOnTimeFactor", competitorJson.get((Object)"timeOnTimeFactor"))).type("text/plain").build();
            }
            try {
                duration = competitorJson.containsKey((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile") ? this.createDurationFromObject(competitorJson.get((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile")) : competitor.getTimeOnDistanceAllowancePerNauticalMile();
            }
            catch (IllegalArgumentException iae) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("invalid %s %s", "timeOnDistanceAllowanceInSecondsPerNauticalMile", competitorJson.get((Object)"timeOnDistanceAllowanceInSecondsPerNauticalMile"))).type("text/plain").build();
            }
            Competitor updatedCompetitor = (Competitor)this.getService().apply((OperationWithResult)new UpdateCompetitor(competitorIdAsString, (String)competitorJson.getOrDefault((Object)"name", (Object)competitor.getName()), (String)competitorJson.getOrDefault((Object)"shortName", (Object)competitor.getShortName()), color, (String)competitorJson.getOrDefault((Object)"email", (Object)competitor.getEmail()), nationality, teamImageUri, flagImageUri, timeOnTimeFactor, duration, (String)competitorJson.getOrDefault((Object)"searchTag", (Object)competitor.getSearchTag())));
            response = Response.ok((Object)this.streamingOutput(CompetitorJsonSerializer.create().serialize(updatedCompetitor))).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Not allowed to update competitor with id '" + StringEscapeUtils.escapeHtml((String)competitorIdAsString) + "'.")).type("text/plain").build();
        }
        return response;
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{competitor-id}/team")
    public Response getTeam(@PathParam(value="competitor-id") String competitorId) {
        DynamicCompetitor competitor = this.getService().getCompetitorAndBoatStore().getExistingCompetitorByIdAsString(competitorId);
        if (competitor == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a competitor with id '" + StringEscapeUtils.escapeHtml((String)competitorId) + "'.")).type("text/plain").build();
        }
        Team team = competitor.getTeam();
        if (team == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a team associated with competitor '" + StringEscapeUtils.escapeHtml((String)competitorId) + "'.")).type("text/plain").build();
        }
        TeamJsonSerializer teamJsonSerializer = new TeamJsonSerializer((JsonSerializer)new PersonJsonSerializer((JsonSerializer)new NationalityJsonSerializer()));
        JSONObject teamJson = teamJsonSerializer.serialize(team);
        return Response.ok((Object)this.streamingOutput(teamJson)).build();
    }

    @POST
    @Consumes(value={"image/jpeg", "image/png"})
    @Path(value="{competitor-id}/team/image")
    @Produces(value={"application/json;charset=UTF-8"})
    public String setTeamImage(@PathParam(value="competitor-id") String competitorId, InputStream uploadedInputStream, @HeaderParam(value="Content-Type") String fileType, @HeaderParam(value="Content-Length") long sizeInBytes, @QueryParam(value="secret") String secret, @QueryParam(value="leaderboardName") String leaderboardName) throws IOException {
        URI imageUri;
        RacingEventService service = this.getService();
        CompetitorAndBoatStore store = service.getCompetitorAndBoatStore();
        DynamicCompetitor competitor = store.getExistingCompetitorByIdAsString(competitorId);
        if (competitor == null) {
            logger.log(Level.INFO, "Could not find competitor to store image for: " + StringEscapeUtils.escapeHtml((String)competitorId));
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Could not find competitor with id " + StringEscapeUtils.escapeHtml((String)competitorId))).type("text/plain").build());
        }
        boolean skip = this.getService().skipChecksDueToCorrectSecret(leaderboardName, secret);
        boolean competitorInRegatta = false;
        if (skip) {
            Regatta regatta = this.getService().getRegattaByName(leaderboardName);
            competitorInRegatta = Util.contains((Iterable)regatta.getAllCompetitors(), (Object)competitor);
        }
        if (!skip || !competitorInRegatta) {
            this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)competitor);
        }
        String fileExtension = "";
        if (fileType.equals("image/jpeg")) {
            fileExtension = ".jpg";
        } else if (fileType.equals("image/png")) {
            fileExtension = ".png";
        }
        if (sizeInBytes <= 0L) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Streams.copy((InputStream)uploadedInputStream, (OutputStream)bos, (boolean)true);
            sizeInBytes = bos.size();
            uploadedInputStream = new ByteArrayInputStream(bos.toByteArray());
        }
        try {
            if (sizeInBytes > 0x500000L) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Image is larger than 5MB").build());
            }
            imageUri = this.getService().getFileStorageManagementService().getActiveFileStorageService().storeFile(uploadedInputStream, fileExtension, sizeInBytes);
        }
        catch (InvalidPropertiesException | OperationFailedException | IOException e) {
            logger.log(Level.WARNING, "Could not store competitor image", e);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Could not store competitor image").type("text/plain").build());
        }
        this.getService().apply((OperationWithResult)new UpdateCompetitor(competitorId, competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), competitor.getTeam().getNationality(), imageUri, competitor.getFlagImage(), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag()));
        logger.log(Level.INFO, "Set team image for competitor " + competitor.getName());
        JSONObject result = new JSONObject();
        result.put((Object)"teamImageUri", (Object)imageUri.toString());
        return result.toString();
    }

    private Color createColorFromString(String colorString) {
        if (colorString == null || colorString.length() == 0) {
            return null;
        }
        return new RGBColor(colorString);
    }

    private URI createURIFromString(String uriString) throws URISyntaxException {
        if (uriString == null || uriString.length() == 0) {
            return null;
        }
        return new URI(uriString);
    }

    private Nationality createNationalityFromString(String nationalityString) {
        if (nationalityString == null || nationalityString.length() == 0) {
            return null;
        }
        return new NationalityImpl(nationalityString);
    }

    private Double createDoubleFromObject(Object number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Number) {
            return ((Number)number).doubleValue();
        }
        throw new IllegalArgumentException("invalid double value");
    }

    private Duration createDurationFromObject(Object number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Number) {
            return new SecondsDurationImpl(((Number)number).doubleValue());
        }
        throw new IllegalArgumentException("invalid duration in seconds value");
    }
}

