/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiWindListener;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.server.gateway.impl.WindStatusServlet;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;

public class WindStatusHtmlServlet
extends WindStatusServlet
implements IgtimiWindListener,
BulkFixReceiver {
    private static final String SAILINGSERVER_WIND_STATUS = "/sailingserver/windStatus";
    private static final long serialVersionUID = 6091476602985063675L;
    private static final Logger logger = Logger.getLogger(WindStatusHtmlServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initializeWindReceiver(false);
        this.writePostRefreshingHeadAndBodyWithRefreshForm(req, resp, "Wind Status", SAILINGSERVER_WIND_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean reinitializeWindReceiver = this.getReloadParamter(req);
        String configureLocalServerPermission = WindStatusHtmlServlet.getPermissionToReload();
        if (reinitializeWindReceiver) {
            SecurityUtils.getSubject().checkPermission(configureLocalServerPermission);
            logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " requested re-initialization of wind receivers");
            this.initializeWindReceiver(true);
            this.writePostRefreshingHeadAndBodyWithRefreshForm(req, resp, "Wind Status", SAILINGSERVER_WIND_STATUS);
        } else {
            resp.setContentType("text/html");
            PrintWriter out = resp.getWriter();
            out.println("<p>last refresh from server: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss")) + "</p>");
            out.println("<h3>Igtimi Wind Status (" + this.getIgtimiMessagesRawCount() + " raw messages received)</h3>");
            Map<LiveDataConnection, WindStatusServlet.IgtimiConnectionInfo> igtimiConnections = WindStatusHtmlServlet.getIgtimiConnections();
            if (!igtimiConnections.isEmpty()) {
                out.println("<h4>Igtimi accounts used</h4>");
                for (Map.Entry<LiveDataConnection, WindStatusServlet.IgtimiConnectionInfo> entry : igtimiConnections.entrySet()) {
                    WindStatusServlet.IgtimiConnectionInfo igtimiConnectionInfo = entry.getValue();
                    int deviceCount = Util.size(igtimiConnectionInfo.getDeviceIDs());
                    out.println(String.valueOf(deviceCount) + " devices " + igtimiConnectionInfo.getDeviceIDs().toString() + "<br/>");
                    InetSocketAddress remoteAddress = igtimiConnectionInfo.getRemoteAddress();
                    out.println("Connection used is " + (remoteAddress == null ? "{null}" : remoteAddress.toString()) + "<br/><br/>");
                }
                out.println("<br/>");
            }
            if (this.getLastIgtimiMessages() != null && !this.getLastIgtimiMessages().isEmpty()) {
                for (Map.Entry<Object, Object> entry : this.getLastIgtimiMessages().entrySet()) {
                    ArrayDeque copyOfLastIgtimiMessages;
                    Deque deviceCount = (Deque)entry.getValue();
                    synchronized (deviceCount) {
                        copyOfLastIgtimiMessages = new ArrayDeque((Collection)entry.getValue());
                    }
                    out.println("Windbot: <b>" + (String)entry.getKey() + "</b>");
                    if (copyOfLastIgtimiMessages.size() > 0) {
                        TimePoint latestTimePoint = ((WindStatusServlet.IgtimiMessageInfo)copyOfLastIgtimiMessages.peek()).getWind().getTimePoint();
                        long lastFixDiffInMs = System.currentTimeMillis() - latestTimePoint.asMillis();
                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;Last fix:");
                        if (lastFixDiffInMs / 1000L < 60L) {
                            out.println(String.valueOf(lastFixDiffInMs / 1000L) + "s ago");
                        } else {
                            out.println("<span style=\"color:red;\">" + lastFixDiffInMs / 1000L / 60L + "min ago</span>");
                        }
                    }
                    out.println("<br/>");
                    for (WindStatusServlet.IgtimiMessageInfo message : copyOfLastIgtimiMessages) {
                        out.println(message);
                        out.println("<br/>");
                    }
                    out.println("<br/>");
                }
            } else if (this.getIgtimiMessagesRawCount() == 0) {
                out.println("<i>No Igtimi messages received so far!</i>");
            } else {
                out.println("<i>" + this.getIgtimiMessagesRawCount() + " Igtimi message bunch has been received but not enough messages to generate wind information.</i>");
            }
            out.println("<h3>Expedition Wind Status</h3>");
            if (this.getLastExpeditionMessages() != null && !this.getLastExpeditionMessages().isEmpty()) {
                ArrayList<WindStatusServlet.ExpeditionMessageInfo> arrayList;
                List<WindStatusServlet.ExpeditionMessageInfo> list = this.getLastExpeditionMessages();
                synchronized (list) {
                    arrayList = new ArrayList<WindStatusServlet.ExpeditionMessageInfo>(this.getLastExpeditionMessages());
                }
                int expeditionMsgCounter = 0;
                ListIterator iterator = arrayList.listIterator(arrayList.size());
                while (iterator.hasPrevious()) {
                    WindStatusServlet.ExpeditionMessageInfo message = (WindStatusServlet.ExpeditionMessageInfo)iterator.previous();
                    out.println(message);
                    out.println("<br/>");
                    if (++expeditionMsgCounter < 100) {
                        continue;
                    }
                    break;
                }
            } else {
                out.println("<i>No Expedition messages received so far!</i>");
            }
            out.close();
        }
    }

    private boolean getReloadParamter(HttpServletRequest req) {
        return Boolean.valueOf(req.getParameter("reloadWindReceiver"));
    }
}

