/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import java.util.Objects;
import org.redisson.client.RedisClient;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;

public class NodeSource {
    private Integer slot;
    private RedisURI addr;
    private RedisClient redisClient;
    private Redirect redirect;
    private MasterSlaveEntry entry;

    public NodeSource(NodeSource nodeSource, RedisClient redisClient) {
        this.slot = nodeSource.slot;
        this.addr = nodeSource.addr;
        this.redisClient = redisClient;
        this.redirect = nodeSource.getRedirect();
        this.entry = nodeSource.getEntry();
    }

    public NodeSource(MasterSlaveEntry entry) {
        this.entry = entry;
    }

    public NodeSource(Integer slot) {
        this.slot = slot;
    }

    public NodeSource(MasterSlaveEntry entry, RedisClient redisClient) {
        this.entry = entry;
        this.redisClient = redisClient;
    }

    public NodeSource(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public NodeSource(Integer slot, RedisClient redisClient) {
        this.slot = slot;
        this.redisClient = redisClient;
    }

    public NodeSource(Integer slot, RedisURI addr, Redirect redirect) {
        this.slot = slot;
        this.addr = addr;
        this.redirect = redirect;
    }

    public MasterSlaveEntry getEntry() {
        return this.entry;
    }

    public Redirect getRedirect() {
        return this.redirect;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public RedisURI getAddr() {
        return this.addr;
    }

    public String toString() {
        return "NodeSource [slot=" + this.slot + ", addr=" + this.addr + ", redisClient=" + this.redisClient + ", redirect=" + (Object)((Object)this.redirect) + ", entry=" + this.entry + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSource that = (NodeSource)o;
        return Objects.equals(this.slot, that.slot) && Objects.equals(this.addr, that.addr) && Objects.equals(this.redisClient, that.redisClient) && this.redirect == that.redirect && Objects.equals(this.entry, that.entry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slot, this.addr, this.redisClient, this.redirect, this.entry});
    }

    public static enum Redirect {
        MOVED,
        ASK;

    }
}

