/*
 * Decompiled with CFR 0.152.
 */
package com.chargebee.models;

import com.chargebee.filters.StringFilter;
import com.chargebee.internal.HttpUtil;
import com.chargebee.internal.ListRequest;
import com.chargebee.internal.Params;
import com.chargebee.internal.Request;
import com.chargebee.internal.Resource;
import com.chargebee.models.enums.AvalaraSaleType;
import com.chargebee.models.enums.PricingModel;
import com.chargebee.org.json.JSONObject;
import java.sql.Timestamp;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbilledCharge
extends Resource<UnbilledCharge> {
    public UnbilledCharge(String jsonStr) {
        super(jsonStr);
    }

    public UnbilledCharge(JSONObject jsonObj) {
        super(jsonObj);
    }

    public String id() {
        return this.optString("id");
    }

    public String customerId() {
        return this.optString("customer_id");
    }

    public String subscriptionId() {
        return this.optString("subscription_id");
    }

    public Timestamp dateFrom() {
        return this.optTimestamp("date_from");
    }

    public Timestamp dateTo() {
        return this.optTimestamp("date_to");
    }

    public Integer unitAmount() {
        return this.optInteger("unit_amount");
    }

    public PricingModel pricingModel() {
        return this.optEnum("pricing_model", PricingModel.class);
    }

    public Integer quantity() {
        return this.optInteger("quantity");
    }

    public Integer amount() {
        return this.optInteger("amount");
    }

    public String currencyCode() {
        return this.reqString("currency_code");
    }

    public Integer discountAmount() {
        return this.optInteger("discount_amount");
    }

    public String description() {
        return this.optString("description");
    }

    public EntityType entityType() {
        return this.reqEnum("entity_type", EntityType.class);
    }

    public String entityId() {
        return this.optString("entity_id");
    }

    public Boolean isVoided() {
        return this.reqBoolean("is_voided");
    }

    public Timestamp voidedAt() {
        return this.optTimestamp("voided_at");
    }

    public String unitAmountInDecimal() {
        return this.optString("unit_amount_in_decimal");
    }

    public String quantityInDecimal() {
        return this.optString("quantity_in_decimal");
    }

    public String amountInDecimal() {
        return this.optString("amount_in_decimal");
    }

    public List<Tier> tiers() {
        return this.optList("tiers", Tier.class);
    }

    public Boolean deleted() {
        return this.reqBoolean("deleted");
    }

    public static CreateRequest create() {
        String uri = UnbilledCharge.uri("unbilled_charges");
        return new CreateRequest(HttpUtil.Method.POST, uri);
    }

    public static InvoiceUnbilledChargesRequest invoiceUnbilledCharges() {
        String uri = UnbilledCharge.uri("unbilled_charges", "invoice_unbilled_charges");
        return new InvoiceUnbilledChargesRequest(HttpUtil.Method.POST, uri);
    }

    public static Request delete(String id) {
        String uri = UnbilledCharge.uri("unbilled_charges", UnbilledCharge.nullCheck(id), "delete");
        return new Request(HttpUtil.Method.POST, uri);
    }

    public static UnbilledChargeListRequest list() {
        String uri = UnbilledCharge.uri("unbilled_charges");
        return new UnbilledChargeListRequest(uri);
    }

    public static InvoiceNowEstimateRequest invoiceNowEstimate() {
        String uri = UnbilledCharge.uri("unbilled_charges", "invoice_now_estimate");
        return new InvoiceNowEstimateRequest(HttpUtil.Method.POST, uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceNowEstimateRequest
    extends Request<InvoiceNowEstimateRequest> {
        private InvoiceNowEstimateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public InvoiceNowEstimateRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public InvoiceNowEstimateRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnbilledChargeListRequest
    extends ListRequest<UnbilledChargeListRequest> {
        private UnbilledChargeListRequest(String uri) {
            super(uri);
        }

        public UnbilledChargeListRequest includeDeleted(Boolean includeDeleted) {
            this.params.addOpt("include_deleted", includeDeleted);
            return this;
        }

        public UnbilledChargeListRequest isVoided(Boolean isVoided) {
            this.params.addOpt("is_voided", isVoided);
            return this;
        }

        public StringFilter<UnbilledChargeListRequest> subscriptionId() {
            return new StringFilter<UnbilledChargeListRequest>("subscription_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        public StringFilter<UnbilledChargeListRequest> customerId() {
            return new StringFilter<UnbilledChargeListRequest>("customer_id", this).supportsMultiOperators(true).supportsPresenceOperator(true);
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InvoiceUnbilledChargesRequest
    extends Request<InvoiceUnbilledChargesRequest> {
        private InvoiceUnbilledChargesRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public InvoiceUnbilledChargesRequest subscriptionId(String subscriptionId) {
            this.params.addOpt("subscription_id", subscriptionId);
            return this;
        }

        public InvoiceUnbilledChargesRequest customerId(String customerId) {
            this.params.addOpt("customer_id", customerId);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateRequest
    extends Request<CreateRequest> {
        private CreateRequest(HttpUtil.Method httpMeth, String uri) {
            super(httpMeth, uri);
        }

        public CreateRequest subscriptionId(String subscriptionId) {
            this.params.add("subscription_id", subscriptionId);
            return this;
        }

        public CreateRequest currencyCode(String currencyCode) {
            this.params.addOpt("currency_code", currencyCode);
            return this;
        }

        public CreateRequest itemPriceItemPriceId(int index, String itemPriceItemPriceId) {
            this.params.addOpt("item_prices[item_price_id][" + index + "]", itemPriceItemPriceId);
            return this;
        }

        public CreateRequest itemPriceQuantity(int index, Integer itemPriceQuantity) {
            this.params.addOpt("item_prices[quantity][" + index + "]", itemPriceQuantity);
            return this;
        }

        public CreateRequest itemPriceQuantityInDecimal(int index, String itemPriceQuantityInDecimal) {
            this.params.addOpt("item_prices[quantity_in_decimal][" + index + "]", itemPriceQuantityInDecimal);
            return this;
        }

        public CreateRequest itemPriceUnitPrice(int index, Integer itemPriceUnitPrice) {
            this.params.addOpt("item_prices[unit_price][" + index + "]", itemPriceUnitPrice);
            return this;
        }

        public CreateRequest itemPriceUnitPriceInDecimal(int index, String itemPriceUnitPriceInDecimal) {
            this.params.addOpt("item_prices[unit_price_in_decimal][" + index + "]", itemPriceUnitPriceInDecimal);
            return this;
        }

        public CreateRequest itemPriceDateFrom(int index, Timestamp itemPriceDateFrom) {
            this.params.addOpt("item_prices[date_from][" + index + "]", itemPriceDateFrom);
            return this;
        }

        public CreateRequest itemPriceDateTo(int index, Timestamp itemPriceDateTo) {
            this.params.addOpt("item_prices[date_to][" + index + "]", itemPriceDateTo);
            return this;
        }

        public CreateRequest itemTierItemPriceId(int index, String itemTierItemPriceId) {
            this.params.addOpt("item_tiers[item_price_id][" + index + "]", itemTierItemPriceId);
            return this;
        }

        public CreateRequest itemTierStartingUnit(int index, Integer itemTierStartingUnit) {
            this.params.addOpt("item_tiers[starting_unit][" + index + "]", itemTierStartingUnit);
            return this;
        }

        public CreateRequest itemTierEndingUnit(int index, Integer itemTierEndingUnit) {
            this.params.addOpt("item_tiers[ending_unit][" + index + "]", itemTierEndingUnit);
            return this;
        }

        public CreateRequest itemTierPrice(int index, Integer itemTierPrice) {
            this.params.addOpt("item_tiers[price][" + index + "]", itemTierPrice);
            return this;
        }

        public CreateRequest itemTierStartingUnitInDecimal(int index, String itemTierStartingUnitInDecimal) {
            this.params.addOpt("item_tiers[starting_unit_in_decimal][" + index + "]", itemTierStartingUnitInDecimal);
            return this;
        }

        public CreateRequest itemTierEndingUnitInDecimal(int index, String itemTierEndingUnitInDecimal) {
            this.params.addOpt("item_tiers[ending_unit_in_decimal][" + index + "]", itemTierEndingUnitInDecimal);
            return this;
        }

        public CreateRequest itemTierPriceInDecimal(int index, String itemTierPriceInDecimal) {
            this.params.addOpt("item_tiers[price_in_decimal][" + index + "]", itemTierPriceInDecimal);
            return this;
        }

        public CreateRequest chargeAmount(int index, Integer chargeAmount) {
            this.params.addOpt("charges[amount][" + index + "]", chargeAmount);
            return this;
        }

        public CreateRequest chargeAmountInDecimal(int index, String chargeAmountInDecimal) {
            this.params.addOpt("charges[amount_in_decimal][" + index + "]", chargeAmountInDecimal);
            return this;
        }

        public CreateRequest chargeDescription(int index, String chargeDescription) {
            this.params.addOpt("charges[description][" + index + "]", chargeDescription);
            return this;
        }

        public CreateRequest chargeTaxable(int index, Boolean chargeTaxable) {
            this.params.addOpt("charges[taxable][" + index + "]", chargeTaxable);
            return this;
        }

        public CreateRequest chargeTaxProfileId(int index, String chargeTaxProfileId) {
            this.params.addOpt("charges[tax_profile_id][" + index + "]", chargeTaxProfileId);
            return this;
        }

        public CreateRequest chargeAvalaraTaxCode(int index, String chargeAvalaraTaxCode) {
            this.params.addOpt("charges[avalara_tax_code][" + index + "]", chargeAvalaraTaxCode);
            return this;
        }

        public CreateRequest chargeTaxjarProductCode(int index, String chargeTaxjarProductCode) {
            this.params.addOpt("charges[taxjar_product_code][" + index + "]", chargeTaxjarProductCode);
            return this;
        }

        public CreateRequest chargeAvalaraSaleType(int index, AvalaraSaleType chargeAvalaraSaleType) {
            this.params.addOpt("charges[avalara_sale_type][" + index + "]", (Object)chargeAvalaraSaleType);
            return this;
        }

        public CreateRequest chargeAvalaraTransactionType(int index, Integer chargeAvalaraTransactionType) {
            this.params.addOpt("charges[avalara_transaction_type][" + index + "]", chargeAvalaraTransactionType);
            return this;
        }

        public CreateRequest chargeAvalaraServiceType(int index, Integer chargeAvalaraServiceType) {
            this.params.addOpt("charges[avalara_service_type][" + index + "]", chargeAvalaraServiceType);
            return this;
        }

        public CreateRequest chargeDateFrom(int index, Timestamp chargeDateFrom) {
            this.params.addOpt("charges[date_from][" + index + "]", chargeDateFrom);
            return this;
        }

        public CreateRequest chargeDateTo(int index, Timestamp chargeDateTo) {
            this.params.addOpt("charges[date_to][" + index + "]", chargeDateTo);
            return this;
        }

        @Override
        public Params params() {
            return this.params;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tier
    extends Resource<Tier> {
        public Tier(JSONObject jsonObj) {
            super(jsonObj);
        }

        public Integer startingUnit() {
            return this.reqInteger("starting_unit");
        }

        public Integer endingUnit() {
            return this.optInteger("ending_unit");
        }

        public Integer quantityUsed() {
            return this.reqInteger("quantity_used");
        }

        public Integer unitAmount() {
            return this.reqInteger("unit_amount");
        }

        public String startingUnitInDecimal() {
            return this.optString("starting_unit_in_decimal");
        }

        public String endingUnitInDecimal() {
            return this.optString("ending_unit_in_decimal");
        }

        public String quantityUsedInDecimal() {
            return this.optString("quantity_used_in_decimal");
        }

        public String unitAmountInDecimal() {
            return this.optString("unit_amount_in_decimal");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntityType {
        PLAN_SETUP,
        PLAN,
        ADDON,
        ADHOC,
        PLAN_ITEM_PRICE,
        ADDON_ITEM_PRICE,
        CHARGE_ITEM_PRICE,
        _UNKNOWN;

    }
}

