/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogRaceStatusEvent;
import java.io.Serializable;
import java.util.Comparator;

public enum RaceLogRaceStatusEventComparator implements Comparator<RaceLogRaceStatusEvent>,
Serializable
{
    INSTANCE;


    @Override
    public int compare(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        int result = this.comparePasses(e1, e2);
        return result == 0 ? this.compareRaceStatus(e1, e2) : result;
    }

    private int comparePasses(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        return e1.getPassId() - e2.getPassId();
    }

    private int compareRaceStatus(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        int result = e1.getNextStatus().getOrderNumber() - e2.getNextStatus().getOrderNumber();
        return result == 0 ? this.compareAuthorPriorities(e1, e2) : result;
    }

    private int compareAuthorPriorities(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        int result = e1.getAuthor().compareTo(e2.getAuthor());
        return result == 0 ? this.compareCreatedAtTimes(e1, e2) : result;
    }

    private int compareCreatedAtTimes(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        int result = e1.getCreatedAt().compareTo((Object)e2.getCreatedAt());
        return result == 0 ? this.compareIds(e1, e2) : result;
    }

    private int compareIds(RaceLogRaceStatusEvent e1, RaceLogRaceStatusEvent e2) {
        return e1.getId().toString().compareTo(e2.getId().toString());
    }
}

