/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.ThresholdBasedResultDiscardingRuleImpl;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractSeriesOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UpdateSeries
extends AbstractSeriesOperation<Void> {
    private static final long serialVersionUID = 6356089749049112710L;
    private final List<FleetDTO> fleets;
    private final boolean isMedal;
    private final boolean isFleetsCanRunInParallel;
    private final int[] resultDiscardingThresholds;
    private final boolean startsWithZeroScore;
    private final boolean firstColumnIsNonDiscardableCarryForward;
    private final boolean hasSplitFleetContiguousScoring;
    private final boolean hasCrossFleetMergedRanking;
    private final boolean seriesNameChanged;
    private final String newSeriesName;
    private final Integer maximumNumberOfDiscards;
    private final boolean oneAlwaysStaysOne;

    public UpdateSeries(RegattaIdentifier regattaIdentifier, String seriesName, String newSeriesName, boolean isMedal, boolean isFleetsCanRunInParallel, int[] resultDiscardingThresholds, boolean startsWithZeroScore, boolean firstColumnIsNonDiscardableCarryForward, boolean hasSplitFleetContiguousScoring, boolean hasCrossFleetMergedRanking, Integer maximumNumberOfDiscards, boolean oneAlwaysStaysOne, List<FleetDTO> fleets) {
        super(regattaIdentifier, seriesName);
        this.seriesNameChanged = !seriesName.equals(newSeriesName);
        this.newSeriesName = newSeriesName;
        this.isMedal = isMedal;
        this.isFleetsCanRunInParallel = isFleetsCanRunInParallel;
        this.resultDiscardingThresholds = resultDiscardingThresholds;
        this.startsWithZeroScore = startsWithZeroScore;
        this.firstColumnIsNonDiscardableCarryForward = firstColumnIsNonDiscardableCarryForward;
        this.hasSplitFleetContiguousScoring = hasSplitFleetContiguousScoring;
        this.hasCrossFleetMergedRanking = hasCrossFleetMergedRanking;
        this.maximumNumberOfDiscards = maximumNumberOfDiscards;
        this.fleets = fleets;
        this.oneAlwaysStaysOne = oneAlwaysStaysOne;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        Series series = this.getSeries(toState);
        if (series == null) {
            series = this.createSeries(toState);
        }
        if (this.seriesNameChanged) {
            series.setName(this.newSeriesName);
        }
        series.setIsMedal(this.isMedal);
        series.setIsFleetsCanRunInParallel(this.isFleetsCanRunInParallel);
        series.setResultDiscardingRule((ThresholdBasedResultDiscardingRule)(this.resultDiscardingThresholds == null ? null : new ThresholdBasedResultDiscardingRuleImpl(this.resultDiscardingThresholds)));
        series.setStartsWithZeroScore(this.startsWithZeroScore);
        series.setFirstColumnIsNonDiscardableCarryForward(this.firstColumnIsNonDiscardableCarryForward);
        series.setSplitFleetContiguousScoring(this.hasSplitFleetContiguousScoring);
        series.setCrossFleetMergedRanking(this.hasCrossFleetMergedRanking);
        series.setMaximumNumberOfDiscards(this.maximumNumberOfDiscards);
        series.setOneAlwaysStaysOne(this.oneAlwaysStaysOne);
        if (series.getRegatta().isPersistent()) {
            toState.updateStoredRegatta(series.getRegatta());
        }
        return null;
    }

    private Series createSeries(RacingEventService toState) {
        Regatta regatta = toState.getRegatta(this.getRegattaIdentifier());
        List emptyRaceColumnNames = Collections.emptyList();
        ArrayList<FleetImpl> result = new ArrayList<FleetImpl>();
        for (FleetDTO fleetNameAndOrderingAndColor : this.fleets) {
            FleetImpl fleet = new FleetImpl(fleetNameAndOrderingAndColor.getName(), fleetNameAndOrderingAndColor.getOrderNo(), fleetNameAndOrderingAndColor.getColor());
            result.add(fleet);
        }
        regatta.addSeries((Series)new SeriesImpl(this.getSeriesName(), this.isMedal, this.isFleetsCanRunInParallel, result, emptyRaceColumnNames, (TrackedRegattaRegistry)toState));
        return regatta.getSeriesByName(this.getSeriesName());
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

