/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;
import java.util.HashSet;
import java.util.Set;

public class UpdateEliminatedCompetitorsInLeaderboard
extends AbstractLeaderboardOperation<Void> {
    private static final long serialVersionUID = -5326008498204072454L;
    private final Set<Competitor> newEliminatedCompetitors;

    public UpdateEliminatedCompetitorsInLeaderboard(String leaderboardName, Set<Competitor> newEliminatedCompetitors) {
        super(leaderboardName);
        this.newEliminatedCompetitors = newEliminatedCompetitors;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        HashSet<Competitor> myNewEliminatedCompetitors = new HashSet<Competitor>(this.newEliminatedCompetitors);
        RegattaLeaderboardWithEliminations leaderboard = (RegattaLeaderboardWithEliminations)toState.getLeaderboardByName(this.getLeaderboardName());
        for (Competitor c : leaderboard.getEliminatedCompetitors()) {
            leaderboard.setEliminated(c, myNewEliminatedCompetitors.remove(c));
        }
        for (Competitor c : myNewEliminatedCompetitors) {
            leaderboard.setEliminated(c, true);
        }
        this.updateStoredLeaderboard(toState, (Leaderboard)leaderboard);
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

