/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.util;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.MarkImpl;
import com.sap.sailing.domain.base.impl.WaypointImpl;
import com.sap.sse.common.Util;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;

public class CourseAsWaypointList
extends AbstractList<Waypoint> {
    private final Course course;
    private final Map<Waypoint, Waypoint> delayedInserts;
    private static final ControlPoint dummyControlPointForPlaceholderWaypoints = new MarkImpl("Dummy mark for placeholder waypoints");

    public CourseAsWaypointList(Course course) {
        this.course = course;
        this.delayedInserts = new HashMap<Waypoint, Waypoint>();
    }

    @Override
    public void add(int index, Waypoint element) {
        if (this.course.getIndexOfWaypoint(element) == -1) {
            this.course.addWaypoint(index, element);
        } else {
            WaypointImpl placeholder = new WaypointImpl(dummyControlPointForPlaceholderWaypoints);
            this.delayedInserts.put(element, (Waypoint)placeholder);
            this.course.addWaypoint(index, (Waypoint)placeholder);
        }
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Waypoint)) {
            return -1;
        }
        return this.course.getIndexOfWaypoint((Waypoint)o);
    }

    @Override
    public Waypoint remove(int index) {
        Waypoint toRemove = this.get(index);
        this.course.removeWaypoint(index);
        Waypoint placeholder = this.delayedInserts.remove(toRemove);
        if (placeholder != null) {
            int placeholderIndex = this.course.getIndexOfWaypoint(placeholder);
            this.course.removeWaypoint(placeholderIndex);
            this.course.addWaypoint(placeholderIndex, toRemove);
        }
        return toRemove;
    }

    @Override
    public Waypoint get(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int i = 0;
        for (Waypoint waypoint : this.course.getWaypoints()) {
            if (i == index) {
                return waypoint;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public int size() {
        return Util.size((Iterable)this.course.getWaypoints());
    }
}

