/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.RegattaListener;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.leaderboard.HasRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.ranking.RankingMetricsFactory;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sse.common.NamedWithID;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.metering.HasCPUMeter;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;

public interface Regatta
extends NamedWithID,
IsRegattaLike,
HasRaceColumnsAndRegattaLike,
WithQualifiedObjectIdentifier,
HasCPUMeter {
    public static final double DEFAULT_BUOY_ZONE_RADIUS_IN_HULL_LENGTHS = 3.0;

    public ScoringScheme getScoringScheme();

    public TimePoint getStartDate();

    public void setStartDate(TimePoint var1);

    public TimePoint getEndDate();

    public void setEndDate(TimePoint var1);

    public Iterable<CourseArea> getCourseAreas();

    public void setCourseAreas(Iterable<CourseArea> var1);

    public RegattaConfiguration getRegattaConfiguration();

    public void setRegattaConfiguration(RegattaConfiguration var1);

    public Iterable<? extends Series> getSeries();

    public void addSeries(Series var1);

    public Series getSeriesByName(String var1);

    public Iterable<RaceDefinition> getAllRaces();

    public RaceDefinition getRaceByName(String var1);

    public BoatClass getBoatClass();

    @Override
    public Iterable<Competitor> getAllCompetitors();

    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered();

    @Override
    public Iterable<Boat> getAllBoats();

    public void removeSeries(Series var1);

    public void addRace(RaceDefinition var1);

    public void removeRace(RaceDefinition var1);

    public void addRegattaListener(RegattaListener var1);

    public void removeRegattaListener(RegattaListener var1);

    public RegattaIdentifier getRegattaIdentifier();

    public boolean isPersistent();

    @Override
    public void addRaceColumnListener(RaceColumnListener var1);

    @Override
    public void removeRaceColumnListener(RaceColumnListener var1);

    public boolean definesSeriesDiscardThresholds();

    public RankingMetricConstructor getRankingMetricConstructor();

    public RegattaAndRaceIdentifier getRaceIdentifier(RaceDefinition var1);

    public Double getBuoyZoneRadiusInHullLengths();

    public void setBuoyZoneRadiusInHullLengths(Double var1);

    public boolean useStartTimeInference();

    public void setUseStartTimeInference(boolean var1);

    public RaceExecutionOrderProvider getRaceExecutionOrderProvider();

    default public RankingMetrics getRankingMetricType() {
        return RankingMetricsFactory.getForClass(((RankingMetric)this.getRankingMetricConstructor().apply(null)).getClass());
    }

    public boolean isControlTrackingFromStartAndFinishTimes();

    public void setControlTrackingFromStartAndFinishTimes(boolean var1);

    public boolean isAutoRestartTrackingUponCompetitorSetChange();

    public void setAutoRestartTrackingUponCompetitorSetChange(boolean var1);

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return Regatta.getTypeRelativeObjectIdentifier(this.getName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String regattaName) {
        return new TypeRelativeObjectIdentifier(new String[]{regattaName});
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(RegattaName regattaName) {
        return new TypeRelativeObjectIdentifier(new String[]{regattaName.getRegattaName()});
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.REGATTA;
    }

    public String getRegistrationLinkSecret();

    public void setRegistrationLinkSecret(String var1);

    public void setCompetitorRegistrationType(CompetitorRegistrationType var1);
}

