/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractColor;

public class HSVColor
extends AbstractColor {
    private static final long serialVersionUID = 7602013229606352246L;
    private final float hue;
    private final float saturation;
    private final float brightness;

    public HSVColor(float hue, float saturation, float brightness) {
        this.hue = this.ensureValidRange(hue, 360.0f);
        this.saturation = this.ensureValidRange(saturation, 1.0f);
        this.brightness = this.ensureValidRange(brightness, 1.0f);
    }

    private float ensureValidRange(float value, float maxValue) {
        float result = value;
        if (value < 0.0f) {
            result = 0.0f;
        } else if (value > maxValue) {
            result = maxValue;
        }
        return result;
    }

    @Override
    public Util.Triple<Integer, Integer, Integer> getAsRGB() {
        float r;
        float g;
        float b;
        if (this.saturation == 0.0f) {
            g = b = this.brightness;
            r = b;
        } else {
            float h = this.hue / 60.0f;
            int i = (int)Math.floor(h);
            float f = h - (float)i;
            float p = this.brightness * (1.0f - this.saturation);
            float q = this.brightness * (1.0f - this.saturation * f);
            float t = this.brightness * (1.0f - this.saturation * (1.0f - f));
            switch (i) {
                case 0: {
                    r = this.brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = this.brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = this.brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = this.brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = this.brightness;
                    break;
                }
                default: {
                    r = this.brightness;
                    g = p;
                    b = q;
                }
            }
        }
        Util.Triple<Integer, Integer, Integer> RGBColor2 = new Util.Triple<Integer, Integer, Integer>(Math.round(r * 255.0f), Math.round(g * 255.0f), Math.round(b * 255.0f));
        return RGBColor2;
    }

    @Override
    public Util.Triple<Float, Float, Float> getAsHSV() {
        return new Util.Triple<Float, Float, Float>(Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }

    public String toString() {
        return "HSVColor [hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + "]";
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.brightness);
        result = 31 * result + Float.floatToIntBits(this.hue);
        result = 31 * result + Float.floatToIntBits(this.saturation);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSVColor other = (HSVColor)obj;
        if (Float.floatToIntBits(this.brightness) != Float.floatToIntBits(other.brightness)) {
            return false;
        }
        if (Float.floatToIntBits(this.hue) != Float.floatToIntBits(other.hue)) {
            return false;
        }
        return Float.floatToIntBits(this.saturation) == Float.floatToIntBits(other.saturation);
    }
}

