/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation.dataproviders;

import com.sap.sse.common.Duration;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.dataproviders.AbstractNumericDataProviderWithStaticMappings;
import java.util.LinkedHashMap;
import java.util.function.Function;

public class DurationDataProvider
extends AbstractNumericDataProviderWithStaticMappings<Duration> {
    private static final String DAYS = "Days";
    private static final String HOURS = "Hours";
    private static final String MINUTES = "Minutes";
    private static final String SECONDS = "Seconds";
    private static final String MILLISECONDS = "Milliseconds";

    public DurationDataProvider() {
        super(Duration.class, DurationDataProvider.getMappings());
    }

    private static LinkedHashMap<String, Function<Duration, Number>> getMappings() {
        LinkedHashMap<String, Function<Duration, Number>> mappings = new LinkedHashMap<String, Function<Duration, Number>>();
        mappings.put(MILLISECONDS, duration -> duration.asMillis());
        mappings.put(SECONDS, duration -> duration.asSeconds());
        mappings.put(MINUTES, duration -> duration.asMinutes());
        mappings.put(HOURS, duration -> duration.asHours());
        mappings.put(DAYS, duration -> duration.asDays());
        return mappings;
    }

    @Override
    public String getDefaultDataKeyFor(QueryResultDTO<?> result) {
        return SECONDS;
    }

    @Override
    public String getLocalizedNameForDataKey(QueryResultDTO<?> result, StringMessages stringMessages, String dataKey) {
        switch (dataKey) {
            case "Days": {
                return stringMessages.days();
            }
            case "Hours": {
                return stringMessages.hours();
            }
            case "Minutes": {
                return stringMessages.minutes();
            }
            case "Seconds": {
                return stringMessages.seconds();
            }
            case "Milliseconds": {
                return stringMessages.milliseconds();
            }
        }
        throw new IllegalArgumentException("The given data key '" + dataKey + "' isn't valid");
    }
}

