/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.BravoFixImpl;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.tracking.DynamicBravoFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.EmptyWindStore;
import com.sap.sailing.domain.tracking.impl.MarkPassingImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Simulator {
    private static final Logger logger = Logger.getLogger(Simulator.class.getName());
    private DynamicTrackedRace trackedRace;
    private final WindStore windStore;
    private boolean stopped;
    private Duration advanceInMillis = Duration.NULL.minus(1L);
    private Timer timer = new Timer("Timer for TracTrac Simulator", true);
    private final Duration offsetToStart;

    public Simulator(WindStore windStore, Duration offsetToStart) {
        assert (windStore != null);
        this.windStore = windStore;
        this.offsetToStart = offsetToStart;
    }

    public WindStore simulatingWindStore(WindStore windStore) {
        return EmptyWindStore.INSTANCE;
    }

    public synchronized void setTrackedRace(DynamicTrackedRace trackedRace) {
        if (trackedRace == null) {
            throw new NullPointerException("Need a valid tracked race here");
        }
        this.trackedRace = trackedRace;
        this.notifyAll();
        trackedRace.getTrackedRegatta().addRaceListener(new RaceListener(){

            public void raceAdded(TrackedRace trackedRace) {
            }

            public void raceRemoved(TrackedRace trackedRace) {
                if (trackedRace == Simulator.this.trackedRace) {
                    Simulator.this.stop();
                }
            }
        }, Optional.empty(), false);
        this.startWindPlayer();
    }

    public synchronized void setAdvanceInMillis(Duration advanceInMillis) {
        this.advanceInMillis = advanceInMillis;
        this.notifyAll();
    }

    private void startWindPlayer() {
        assert (this.trackedRace != null);
        for (final Map.Entry windSourceAndTrack : this.windStore.loadWindTracks(this.trackedRace.getTrackedRegatta().getRegatta().getName(), (TrackedRace)this.trackedRace, 10000L).entrySet()) {
            Thread windSimulatorThread = new Thread("Wind simulator for wind source " + windSourceAndTrack.getKey() + " for tracked race " + this.trackedRace.getRace().getName()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    block13: {
                        Simulator simulator = Simulator.this;
                        synchronized (simulator) {
                            while (true) {
                                while (true) {
                                    if (Simulator.this.trackedRace != null) {
                                        break block13;
                                    }
                                    try {
                                        Simulator.this.wait();
                                    }
                                    catch (InterruptedException e) {
                                        logger.log(Level.INFO, "Exception waiting for tracked race to arrive in simulator", e);
                                    }
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    WindTrack windTrack = (WindTrack)windSourceAndTrack.getValue();
                    windTrack.lockForRead();
                    try {
                        for (Wind wind : windTrack.getRawFixes()) {
                            if (!Simulator.this.stopped) {
                                Simulator.this.trackedRace.recordWind(Simulator.this.delayWind(wind), (WindSource)windSourceAndTrack.getKey());
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        windTrack.unlockAfterRead();
                    }
                    logger.info("Wind Track Simulator for race " + Simulator.this.trackedRace.getRace().getName() + " finished. stopped=" + Simulator.this.stopped);
                }
            };
            windSimulatorThread.setDaemon(true);
            windSimulatorThread.start();
        }
    }

    private Wind delayWind(Wind wind) {
        TimePoint delayedTimePoint = this.delay(wind.getTimePoint());
        return new WindImpl(wind.getPosition(), delayedTimePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(wind.getKnots(), wind.getBearing()));
    }

    private synchronized Duration getAdvance() {
        while (!this.isAdvanceInMillisSet()) {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                logger.throwing(Simulator.class.getName(), "getAdvanceInMillis", e);
            }
        }
        return this.advanceInMillis;
    }

    private Duration getOffsetToStart() {
        Duration result = this.offsetToStart != null ? this.offsetToStart : Duration.NULL;
        return result;
    }

    public TimePoint delay(TimePoint timePoint) {
        TimePoint transformedTimed = this.advance(timePoint);
        long waitTimeInMillis = this.getWaitTimeInMillisUntil(transformedTimed);
        do {
            if (waitTimeInMillis <= 0L) continue;
            try {
                Thread.sleep(waitTimeInMillis);
                waitTimeInMillis = 0L;
            }
            catch (InterruptedException e) {
                waitTimeInMillis = transformedTimed.asMillis() - System.currentTimeMillis();
            }
        } while (waitTimeInMillis > 0L);
        return transformedTimed;
    }

    private long getWaitTimeInMillisUntil(TimePoint transformedTimepoint) {
        long now = System.currentTimeMillis();
        long waitTimeInMillis = transformedTimepoint.asMillis() - now;
        return waitTimeInMillis;
    }

    public TimePoint advance(TimePoint timePoint) {
        return timePoint.plus(this.getAdvance());
    }

    public TimePoint advanceMarkPassingTimePoint(TimePoint time) {
        return this.advanceTimePointAndUseAsStartTimeIfNeeded(time);
    }

    public TimePoint advanceStartTime(TimePoint raceStartTime) {
        return this.advanceTimePointAndUseAsStartTimeIfNeeded(raceStartTime);
    }

    private TimePoint advanceTimePointAndUseAsStartTimeIfNeeded(TimePoint time) {
        if (this.isAdvanceInMillisSet()) {
            return this.advance(time);
        }
        this.setAdvanceInMillis((Duration)new MillisecondsDurationImpl(MillisecondsTimePoint.now().minus(time.asMillis()).plus(this.getOffsetToStart()).asMillis()));
        return this.advance(time);
    }

    private boolean isAdvanceInMillisSet() {
        return !this.advanceInMillis.equals(Duration.NULL.minus(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delayMarkPassings(final Competitor competitor, List<MarkPassing> markPassings) {
        TimePoint transformedTimepoint;
        MarkPassing markPassing;
        Iterator<MarkPassing> i;
        ArrayList<MarkPassing> deliverLater;
        ArrayList<MarkPassingImpl> deliverTransformedNow;
        block12: {
            deliverTransformedNow = new ArrayList<MarkPassingImpl>();
            deliverLater = new ArrayList<MarkPassing>();
            i = markPassings.iterator();
            if (!i.hasNext()) {
                this.trackedRace.updateMarkPassings(competitor, markPassings);
                return;
            }
            markPassing = i.next();
            deliverLater.add(markPassing);
            transformedTimepoint = this.advanceMarkPassingTimePoint(markPassing.getTimePoint());
            while (this.getWaitTimeInMillisUntil(transformedTimepoint) <= 0L && markPassing != null) {
                MarkPassingImpl transformedMarkPassing = new MarkPassingImpl(transformedTimepoint, markPassing.getWaypoint(), markPassing.getCompetitor());
                deliverTransformedNow.add(transformedMarkPassing);
                if (i.hasNext()) {
                    markPassing = i.next();
                    transformedTimepoint = this.advanceMarkPassingTimePoint(markPassing.getTimePoint());
                    deliverLater.add(markPassing);
                    continue;
                }
                markPassing = null;
            }
            Simulator simulator = this;
            synchronized (simulator) {
                while (true) {
                    while (true) {
                        if (this.trackedRace != null) {
                            break block12;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.INFO, "Exception waiting for tracked race to arrive in simulator", e);
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        this.trackedRace.updateMarkPassings(competitor, deliverTransformedNow);
        if (markPassing == null) return;
        while (i.hasNext()) {
            deliverLater.add(i.next());
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Simulator.this.delayMarkPassings(competitor, deliverLater);
                }
                catch (Exception e) {
                    logger.throwing(Simulator.class.getName(), "scheduleMarkPosition", e);
                }
            }
        }, transformedTimepoint.asDate());
    }

    public void scheduleCompetitorPosition(Competitor competitor, GPSFixMoving competitorFix) {
        RecordGPSFix<Competitor> recorder = (c, f) -> {
            Simulator simulator = this;
            synchronized (simulator) {
                while (this.trackedRace == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.INFO, "Exception waiting for tracked race to arrive in simulator", e);
                    }
                }
            }
            this.trackedRace.recordFix(c, f);
        };
        this.scheduleFixRecording(competitor, competitorFix, recorder);
    }

    public void scheduleMarkPosition(Mark mark, GPSFixMoving markFix) {
        RecordGPSFix<Mark> recorder = (m, f) -> {
            Simulator simulator = this;
            synchronized (simulator) {
                while (this.trackedRace == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.INFO, "Exception waiting for tracked race to arrive in simulator", e);
                    }
                }
            }
            this.trackedRace.recordFix(mark, (GPSFix)f);
        };
        this.scheduleFixRecording(mark, markFix, recorder);
    }

    public void scheduleCompetitorSensorData(final DynamicBravoFixTrack<Competitor> bravoFixTrack, BravoFix fix) {
        TimePoint transformedTimepoint = this.advance(fix.getTimePoint());
        BravoFixImpl transformedFix = new BravoFixImpl((DoubleVectorFix)new DoubleVectorFixImpl(transformedTimepoint, fix.get()));
        long waitTime = this.getWaitTimeInMillisUntil(transformedFix.getTimePoint());
        if (waitTime <= 0L) {
            bravoFixTrack.add((Timed)transformedFix);
        } else {
            this.timer.schedule(new TimerTask((BravoFix)transformedFix){
                private final /* synthetic */ BravoFix val$transformedFix;
                {
                    this.val$transformedFix = bravoFix;
                }

                @Override
                public void run() {
                    try {
                        bravoFixTrack.add((Timed)this.val$transformedFix);
                    }
                    catch (Exception e) {
                        logger.throwing(Simulator.class.getName(), "scheduleSensorData", e);
                    }
                }
            }, transformedTimepoint.asDate());
        }
    }

    private <T> void scheduleFixRecording(final T object, GPSFixMoving fix, final RecordGPSFix<T> recorder) {
        TimePoint transformedTimepoint = this.advance(fix.getTimePoint());
        GPSFixMovingImpl transformedFix = new GPSFixMovingImpl(fix.getPosition(), transformedTimepoint, fix.getSpeed(), fix.getOptionalTrueHeading());
        long waitTime = this.getWaitTimeInMillisUntil(transformedFix.getTimePoint());
        if (waitTime <= 0L) {
            recorder.recordFix(object, (GPSFixMoving)transformedFix);
        } else {
            this.timer.schedule(new TimerTask((GPSFixMoving)transformedFix){
                private final /* synthetic */ GPSFixMoving val$transformedFix;
                {
                    this.val$transformedFix = gPSFixMoving;
                }

                @Override
                public void run() {
                    try {
                        recorder.recordFix(object, this.val$transformedFix);
                    }
                    catch (Exception e) {
                        logger.throwing(Simulator.class.getName(), "schedulePosition", e);
                    }
                }
            }, transformedTimepoint.asDate());
        }
    }

    public void stop() {
        logger.info("Stopping simulator for race " + this.trackedRace.getRace().getName());
        this.timer.cancel();
        this.stopped = true;
    }

    @FunctionalInterface
    private static interface RecordGPSFix<T> {
        public void recordFix(T var1, GPSFixMoving var2);
    }
}

