/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.landscape.common.shared.SecuredLandscapeTypes;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SSHKeyPair
extends NamedImpl
implements Named,
WithQualifiedObjectIdentifier {
    private static final long serialVersionUID = 2877813132246472243L;
    private final String regionId;
    private final String creatorName;
    private final TimePoint creationTime;
    private final byte[] publicKey;
    private final byte[] encryptedPrivateKey;

    public SSHKeyPair(String regionId, String creatorName, TimePoint creationTime, String keyName, byte[] publicKey, byte[] unencryptedPrivateKey, byte[] privateKeyEncryptionPassphrase) throws JSchException {
        this(regionId, creatorName, creationTime, keyName, publicKey, SSHKeyPair.encryptPrivateKey(unencryptedPrivateKey, privateKeyEncryptionPassphrase));
    }

    private static byte[] encryptPrivateKey(byte[] unencryptedPrivateKey, byte[] privateKeyEncryptionPassphrase) throws JSchException {
        if (privateKeyEncryptionPassphrase.length == 0) {
            throw new IllegalArgumentException("Non-empty passphrase required to protect private key");
        }
        KeyPair keyPair = KeyPair.load((JSch)new JSch(), (byte[])unencryptedPrivateKey, null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        keyPair.writePrivateKey((OutputStream)bos, privateKeyEncryptionPassphrase);
        return bos.toByteArray();
    }

    public SSHKeyPair(String regionId, String creatorName, TimePoint creationTime, String keyName, byte[] publicKey, byte[] encryptedPrivateKey) {
        super(keyName);
        this.regionId = regionId;
        this.creatorName = creatorName;
        this.creationTime = creationTime;
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }

    public KeyPair getKeyPair(JSch jsch, byte[] passphrase) throws JSchException {
        KeyPair result = KeyPair.load((JSch)jsch, (byte[])this.getEncryptedPrivateKey(), (byte[])this.getPublicKey());
        if (!result.decrypt(passphrase)) {
            throw new IllegalStateException("Could not decrypt private key of " + (Object)((Object)this) + "; probably incorrect passphrase?");
        }
        return result;
    }

    public boolean checkPassphrase(JSch jsch, byte[] passphrase) {
        boolean res;
        try {
            KeyPair result = KeyPair.load((JSch)jsch, (byte[])this.getEncryptedPrivateKey(), (byte[])this.getPublicKey());
            res = result.decrypt(passphrase);
        }
        catch (JSchException e) {
            res = false;
        }
        return res;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public TimePoint getCreationTime() {
        return this.creationTime;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{this.getRegionId(), this.getName()}));
    }

    public HasPermissions getPermissionType() {
        return SecuredLandscapeTypes.SSH_KEY;
    }
}

