/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb.impl;

import com.sap.sse.landscape.mongodb.MongoProcessInReplicaSet;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.MongoEndpointImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MongoReplicaSetImpl
extends MongoEndpointImpl
implements MongoReplicaSet {
    private static final long serialVersionUID = 2055195945588247106L;
    private final String name;
    private final Set<MongoProcessInReplicaSet> instances;

    public MongoReplicaSetImpl(String name) {
        this.name = name;
        this.instances = new HashSet<MongoProcessInReplicaSet>();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterable<MongoProcessInReplicaSet> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }

    @Override
    public void addReplica(MongoProcessInReplicaSet newReplica) {
        this.instances.add(newReplica);
    }

    @Override
    public void removeReplica(MongoProcessInReplicaSet replicaToRemove) {
        this.instances.remove(replicaToRemove);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instances == null ? 0 : this.instances.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MongoReplicaSetImpl other = (MongoReplicaSetImpl)obj;
        if (this.instances == null ? other.instances != null : !this.instances.equals(other.instances)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

