/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.topologicalordering;

import com.sap.sse.util.graph.DirectedGraph;
import java.util.Comparator;
import java.util.Map;

public class TopologicalComparator<T>
implements Comparator<T> {
    private final DirectedGraph<T> graph;
    private final Map<T, Integer> lengthsOfLongestPathsFromRoot;

    public TopologicalComparator(DirectedGraph<T> graph) {
        this.graph = graph;
        this.lengthsOfLongestPathsFromRoot = graph.getLengthsOfLongestPathsFromRoot();
    }

    @Override
    public int compare(T o1, T o2) {
        int result = o1.equals(o2) || this.graph.areOnSameCycleCluster(o1, o2) ? 0 : (this.graph.hasPath(o1, o2) ? -1 : (this.graph.hasPath(o2, o1) ? 1 : Integer.compare(this.lengthsOfLongestPathsFromRoot.get(o1), this.lengthsOfLongestPathsFromRoot.get(o2))));
        return result;
    }
}

