/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gateway;

import com.sap.sse.InvalidDateException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.DateParser;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;

public abstract class AbstractHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -6514453597593669376L;
    protected static final String PARAM_NAME_TIME = "time";
    protected static final String PARAM_NAME_TIME_MILLIS = "timeasmillis";
    private static final String OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME = "osgi-bundlecontext";
    private BundleContext context;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = (BundleContext)config.getServletContext().getAttribute(OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME);
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected TimePoint readTimePointParam(HttpServletRequest req, String nameOfISOTimeParam, String nameOfMillisTime) throws InvalidDateException {
        return this.readTimePointParam(req, nameOfISOTimeParam, nameOfMillisTime, null);
    }

    protected TimePoint readTimePointParam(HttpServletRequest req, String nameOfISOTimeParam, String nameOfMillisTime, TimePoint defaultValue) throws InvalidDateException {
        String timeAsMillis;
        String time = req.getParameter(nameOfISOTimeParam);
        Object timePoint = time != null && time.length() > 0 ? new MillisecondsTimePoint(DateParser.parse(time).getTime()) : ((timeAsMillis = req.getParameter(nameOfMillisTime)) != null && timeAsMillis.length() > 0 ? new MillisecondsTimePoint(Long.valueOf(timeAsMillis).longValue()) : defaultValue);
        return timePoint;
    }
}

