/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.aggregators;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.PairWithStats;
import com.sap.sse.datamining.shared.impl.PairWithStatsImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelGroupedNumberPairCollectingProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Util.Pair, PairWithStats<Number>> {
    private static final Class<?> _c = PairWithStats.class;
    private static final Class<PairWithStats<Number>> _cc = _c;
    private static final AggregationProcessorDefinition<Util.Pair, PairWithStats<Number>> DEFINITION = new SimpleAggregationProcessorDefinition<Util.Pair, PairWithStats<Number>>(Util.Pair.class, _cc, "PairCollecting", ParallelGroupedNumberPairCollectingProcessor.class);
    private final Map<GroupKey, HashSet<Util.Pair<Number, Number>>> individualPairs = new HashMap<GroupKey, HashSet<Util.Pair<Number, Number>>>();
    private final Map<GroupKey, AtomicLong> elementAmountPerKey = new HashMap<GroupKey, AtomicLong>();

    public static AggregationProcessorDefinition<Util.Pair, PairWithStats<Number>> getDefinition() {
        return DEFINITION;
    }

    public ParallelGroupedNumberPairCollectingProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, PairWithStats<Number>>, ?>> resultReceivers) {
        super(executor, resultReceivers, "PairCollecting");
    }

    @Override
    protected void storeElement(GroupedDataEntry<Util.Pair> element) {
        if (element.getDataEntry() != null) {
            Double doubleValueB;
            this.incrementElementAmount(element);
            HashSet<Object> aggregate = this.individualPairs.get(element.getKey());
            Number a = (Number)element.getDataEntry().getA();
            Number b = (Number)element.getDataEntry().getB();
            Double doubleValueA = a == null ? null : Double.valueOf(a.doubleValue());
            Double d = doubleValueB = b == null ? null : Double.valueOf(b.doubleValue());
            if (doubleValueA != null && doubleValueB != null) {
                if (aggregate == null) {
                    aggregate = new HashSet();
                    aggregate.add((Util.Pair<Number, Number>)new Util.Pair((Object)doubleValueA, (Object)doubleValueB));
                    this.individualPairs.put(element.getKey(), aggregate);
                } else {
                    this.individualPairs.get(element.getKey()).add((Util.Pair<Number, Number>)new Util.Pair((Object)doubleValueA, (Object)doubleValueB));
                }
            }
        }
    }

    private void incrementElementAmount(GroupedDataEntry<Util.Pair> element) {
        GroupKey key = element.getKey();
        AtomicLong currentAmount = this.elementAmountPerKey.get(key);
        if (currentAmount == null) {
            this.elementAmountPerKey.put(key, new AtomicLong(1L));
        } else {
            currentAmount.incrementAndGet();
        }
    }

    @Override
    protected Map<GroupKey, PairWithStats<Number>> aggregateResult() {
        HashMap<GroupKey, PairWithStats<Number>> result = new HashMap<GroupKey, PairWithStats<Number>>();
        for (Map.Entry<GroupKey, HashSet<Util.Pair<Number, Number>>> sumAggregationEntry : this.individualPairs.entrySet()) {
            if (this.isAborted()) break;
            GroupKey key = sumAggregationEntry.getKey();
            result.put(key, (PairWithStats<Number>)new PairWithStatsImpl(null, null, null, null, null, this.individualPairs.get(key), this.elementAmountPerKey.get(key).get(), Util.Pair.class.getName()));
        }
        return result;
    }
}

