/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.components.management.AggregationProcessorDefinitionProvider;
import com.sap.sse.datamining.components.management.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.components.management.FunctionProvider;
import com.sap.sse.datamining.components.management.QueryDefinitionDTOProvider;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.management.ReducedDimensions;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.shared.classloading.JoinedClassLoader;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public interface DataMiningServer {
    public ExecutorService getExecutorService();

    public ResourceBundleStringMessages getStringMessages();

    public Date getComponentsChangedTimepoint();

    public FunctionProvider getFunctionProvider();

    public Function<?> getFunctionForDTO(FunctionDTO var1);

    public DataRetrieverChainDefinitionProvider getDataRetrieverChainDefinitionProvider();

    public <DataSourceType, DataType> DataRetrieverChainDefinition<DataSourceType, DataType> getDataRetrieverChainDefinitionForDTO(DataRetrieverChainDefinitionDTO var1);

    public AggregationProcessorDefinitionProvider getAggregationProcessorProvider();

    public <ExtractedType, ResultType> AggregationProcessorDefinition<ExtractedType, ResultType> getAggregationProcessorDefinitionForDTO(AggregationProcessorDefinitionDTO var1);

    public QueryDefinitionDTOProvider getQueryDefinitionDTOProvider();

    public <DataSourceType> Query<HashSet<Object>> createDimensionValuesQuery(DataRetrieverChainDefinition<DataSourceType, ?> var1, DataRetrieverLevel<?, ?> var2, Iterable<Function<?>> var3, Map<DataRetrieverLevel<?, ?>, SerializableSettings> var4, Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> var5, Locale var6);

    public <DataSourceType, DataType, ExtractedType, ResultType> StatisticQueryDefinition<DataSourceType, DataType, ExtractedType, ResultType> getQueryDefinitionForDTO(StatisticQueryDefinitionDTO var1);

    public <DataSourceType, ResultType> Query<ResultType> createQuery(StatisticQueryDefinition<DataSourceType, ?, ?, ResultType> var1);

    public <ResultType> QueryResult<ResultType> runNewQueryAndAbortPreviousQueries(DataMiningSession var1, Query<ResultType> var2);

    public int getNumberOfRunningQueries();

    public JoinedClassLoader getJoinedClassLoader();

    public StatisticQueryDefinitionDTO fromBase64String(String var1);

    default public Function<?> getIdentityFunction() {
        return this.getFunctionProvider().getIdentityFunction();
    }

    default public Iterable<Function<?>> getAllStatistics() {
        return this.getFunctionProvider().getAllStatistics();
    }

    default public Iterable<Function<?>> getFunctionsFor(Class<?> sourceType) {
        return this.getFunctionProvider().getFunctionsFor(sourceType);
    }

    default public Iterable<Function<?>> getStatisticsFor(Class<?> sourceType) {
        return this.getFunctionProvider().getStatisticsFor(sourceType);
    }

    default public Iterable<Function<?>> getDimensionsFor(Class<?> sourceType) {
        return this.getFunctionProvider().getDimensionsFor(sourceType);
    }

    default public Map<DataRetrieverLevel<?, ?>, Iterable<Function<?>>> getDimensionsMappedByLevelFor(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        return this.getFunctionProvider().getDimensionsMappedByLevelFor(dataRetrieverChainDefinition);
    }

    default public ReducedDimensions getReducedDimensionsMappedByLevelFor(DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition) {
        return this.getFunctionProvider().getReducedDimensionsMappedByLevelFor(dataRetrieverChainDefinition);
    }

    default public Iterable<DataRetrieverChainDefinition<?, ?>> getDataRetrieverChainDefinitions() {
        return this.getDataRetrieverChainDefinitionProvider().getAll();
    }

    default public <DataSourceType> Iterable<DataRetrieverChainDefinition<DataSourceType, ?>> getDataRetrieverChainDefinitionsBySourceType(Class<DataSourceType> dataSourceType) {
        return this.getDataRetrieverChainDefinitionProvider().getBySourceType(dataSourceType);
    }

    default public <DataType> Iterable<DataRetrieverChainDefinition<?, DataType>> getDataRetrieverChainDefinitionsByDataType(Class<DataType> retrievedDataType) {
        return this.getDataRetrieverChainDefinitionProvider().getByDataType(retrievedDataType);
    }

    default public <DataSourceType, DataType> Iterable<DataRetrieverChainDefinition<DataSourceType, DataType>> getDataRetrieverChainDefinitions(Class<DataSourceType> dataSourceType, Class<DataType> retrievedDataType) {
        return this.getDataRetrieverChainDefinitionProvider().get(dataSourceType, retrievedDataType);
    }

    default public Iterable<AggregationProcessorDefinition<?, ?>> getAllAggregationProcessorDefinitions() {
        return this.getAggregationProcessorProvider().getAll();
    }

    default public <ExtractedType> Iterable<AggregationProcessorDefinition<? super ExtractedType, ?>> getAggregationProcessorDefinitions(Class<ExtractedType> extractedType) {
        return this.getAggregationProcessorProvider().getByExtractedType(extractedType);
    }

    default public <ExtractedType> AggregationProcessorDefinition<? super ExtractedType, ?> getAggregationProcessorDefinition(Class<ExtractedType> extractedType, String aggregationNameMessageKey) {
        return this.getAggregationProcessorProvider().get(extractedType, aggregationNameMessageKey);
    }

    default public Iterable<PredefinedQueryIdentifier> getPredefinedQueryIdentifiers() {
        return this.getQueryDefinitionDTOProvider().getIdentifiers();
    }

    default public ModifiableStatisticQueryDefinitionDTO getPredefinedQueryDefinitionDTO(PredefinedQueryIdentifier identifier) {
        return this.getQueryDefinitionDTOProvider().get(identifier);
    }
}

