/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.velum.resultimport.impl;

import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.AbstractDocumentBasedScoreCorrectionProvider;
import com.sap.sailing.resultimport.impl.RegattaScoreCorrectionsImpl;
import com.sap.sailing.velum.resultimport.CsvParser;
import com.sap.sailing.velum.resultimport.CsvParserFactory;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ScoreCorrectionProviderImpl
extends AbstractDocumentBasedScoreCorrectionProvider {
    private static final long serialVersionUID = 4767200739966995306L;
    private static final String NAME = "Velum CSV result importer";
    private static final Logger logger = Logger.getLogger(ScoreCorrectionProviderImpl.class.getName());
    private final CsvParserFactory parserFactory;

    public ScoreCorrectionProviderImpl(ResultDocumentProvider documentProvider, CsvParserFactory parserFactory) {
        super(documentProvider);
        this.parserFactory = parserFactory;
    }

    public String getName() {
        return NAME;
    }

    public Map<String, Set<Util.Pair<String, TimePoint>>> getHasResultsForBoatClassFromDateByEventName() throws Exception {
        HashMap<String, Set<Util.Pair<String, TimePoint>>> result = new HashMap<String, Set<Util.Pair<String, TimePoint>>>();
        for (CsvParser parser : this.getAllRegattaResults()) {
            try {
                parser.parseResults();
                String boatClass = parser.getBoatClass();
                result.put(parser.getFilename(), Collections.singleton(new Util.Pair((Object)boatClass, (Object)parser.getLastModified())));
            }
            catch (Exception e) {
                logger.info("Parse error during CSV import. Ignoring document " + parser.toString());
                logger.throwing(ScoreCorrectionProviderImpl.class.getName(), "getHasResultsForBoatClassFromDateByEventName", e);
            }
        }
        return result;
    }

    public RegattaScoreCorrections getScoreCorrections(String eventName, String boatClassName, TimePoint timePointPublished) throws Exception {
        for (CsvParser parser : this.getAllRegattaResults()) {
            try {
                if (!parser.getFilename().equals(eventName)) continue;
                RegattaResults regattaResult = parser.parseResults();
                return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, regattaResult);
            }
            catch (Exception e) {
                logger.info("Parse error during CSV import. Ignoring document " + parser.toString());
                logger.throwing(ScoreCorrectionProviderImpl.class.getName(), "getScoreCorrections", e);
            }
        }
        return null;
    }

    public RegattaScoreCorrections getScoreCorrections(InputStream inputStream) throws Exception {
        CsvParser parser = this.parserFactory.createParser(inputStream, inputStream.toString(), MillisecondsTimePoint.now());
        return new RegattaScoreCorrectionsImpl((ScoreCorrectionProvider)this, parser.parseResults());
    }

    private Iterable<CsvParser> getAllRegattaResults() throws Exception {
        ArrayList<CsvParser> result = new ArrayList<CsvParser>();
        for (ResultDocumentDescriptor resultDocDescr : this.getResultDocumentProvider().getResultDocumentDescriptors()) {
            CsvParser parser = this.parserFactory.createParser(resultDocDescr.getInputStream(), resultDocDescr.getDocumentName(), resultDocDescr.getLastModified());
            result.add(parser);
        }
        return result;
    }
}

