/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.swisstimingadapter.MessageType;
import com.sap.sailing.domain.swisstimingadapter.impl.AbstractSailMasterConnector;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingRaceTrackerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SailMasterConnectorForSocket
extends AbstractSailMasterConnector {
    private static final Logger logger = Logger.getLogger(SailMasterConnectorForSocket.class.getName());
    private final String host;
    private final int port;
    private Socket socket;

    public SailMasterConnectorForSocket(String host, int port, String raceId, String raceName, String raceDescription, BoatClass boatClass, SwissTimingRaceTrackerImpl swissTimingRaceTracker) throws InterruptedException, ParseException {
        super(raceId, raceName, raceDescription, boatClass, swissTimingRaceTracker);
        this.host = host;
        this.port = port;
        this.startReceiverThread();
    }

    @Override
    protected void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Exception trying to close socket. Maybe already closed. Continuing", e);
            }
            this.socket = null;
        }
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    protected void connect() throws IOException {
        logger.info("Opening socket to " + this.host + ":" + this.port + " and sending " + MessageType.OPN.name() + " message...");
        this.socket = new Socket(this.host, this.port);
    }

    @Override
    protected boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    protected TrackedRaceStatusEnum getStatusAfterLoadingIsComplete() {
        return TrackedRaceStatusEnum.TRACKING;
    }
}

