/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButton;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButtonDialog;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFooterPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagInputPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagPreviewPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.ImagesBarColumn;
import com.sap.sse.gwt.client.dialog.ConfirmationDialog;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.List;

public class TagButtonDialog
extends DialogBox {
    private final TaggingPanelResources resources = TaggingPanelResources.INSTANCE;
    private final TaggingPanelResources.TagPanelStyle style = this.resources.style();
    private final TaggingComponent taggingComponent;
    private final StringMessages stringMessages;
    private final TagInputPanel inputPanel;
    private final TagPreviewPanel tagPreviewPanel;
    private final CellTable<TagButton> tagButtonTable;
    private final TagFooterPanel footerPanel;
    private TagButton selectedTagButton;
    private boolean updateTagMode = false;

    public TagButtonDialog(TaggingComponent taggingComponent, TagFooterPanel footerPanel, SailingServiceAsync sailingService, StringMessages stringMessages, UserService userService, RaceIdentifier raceIdentifier) {
        this.taggingComponent = taggingComponent;
        this.stringMessages = stringMessages;
        this.footerPanel = footerPanel;
        this.setGlassEnabled(true);
        this.setText(stringMessages.tagEditCustomTagButtons());
        this.addStyleName(this.style.tagButtonDialog());
        this.inputPanel = new TagInputPanel(taggingComponent, sailingService, stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.tagPreviewPanel = new TagPreviewPanel(taggingComponent, this.inputPanel, stringMessages, userService, raceIdentifier);
        this.tagButtonTable = this.createTable(footerPanel, this.inputPanel, this.tagPreviewPanel);
        this.tagButtonTable.addRedrawHandler(() -> this.center());
        Panel controlButtonPanel = this.createButtonPanel(this.tagButtonTable, this.inputPanel, this.tagPreviewPanel, footerPanel);
        this.setButtonMode(false);
        SimplePanel tagButtonsTableWrapper = new SimplePanel();
        tagButtonsTableWrapper.setStyleName(this.style.tagButtonTableWrapper());
        tagButtonsTableWrapper.add((Widget)this.tagButtonTable);
        FlowPanel mainPanel = new FlowPanel();
        mainPanel.setStyleName(this.style.tagButtonDialogPanel());
        mainPanel.add((Widget)tagButtonsTableWrapper);
        mainPanel.add((Widget)this.inputPanel.getStatusLabel());
        mainPanel.add((Widget)this.inputPanel);
        mainPanel.add((Widget)controlButtonPanel);
        mainPanel.add((Widget)this.tagPreviewPanel);
        this.setWidget((Widget)mainPanel);
        this.center();
    }

    private CellTable<TagButton> createTable(TagFooterPanel footerPanel, TagInputPanel inputPanel, TagPreviewPanel tagPreviewPanel) {
        CellTable tagButtonTable = new CellTable(15, (CellTable.Resources)this.resources);
        tagButtonTable.setStyleName(this.style.tagButtonTable());
        ImageWithTextCell imageWithTextCell = new ImageWithTextCell(this, null);
        2 tagColumn = new /* Unavailable Anonymous Inner Class!! */;
        3 imageURLColumn = new /* Unavailable Anonymous Inner Class!! */;
        4 commentColumn = new /* Unavailable Anonymous Inner Class!! */;
        ImagesBarColumn actionsColumn = new ImagesBarColumn((ImagesBarCell)new EditTagButtonsImagesBarCell(this, this.stringMessages));
        actionsColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        tagButtonTable.addColumn((Column)tagColumn, this.stringMessages.tagLabelTag());
        tagButtonTable.addColumn((Column)imageURLColumn, this.stringMessages.tagLabelImage());
        tagButtonTable.addColumn((Column)commentColumn, this.stringMessages.tagLabelComment());
        tagButtonTable.addColumn((Column)actionsColumn, this.stringMessages.tagLabelAction());
        tagButtonTable.setColumnWidth((Column)tagColumn, "25%");
        tagButtonTable.setColumnWidth((Column)imageURLColumn, "20%");
        tagButtonTable.setColumnWidth((Column)commentColumn, "40%");
        tagButtonTable.setColumnWidth((Column)actionsColumn, "15%");
        this.setRowData(tagButtonTable, this.taggingComponent.getTagButtons());
        return tagButtonTable;
    }

    private Panel createButtonPanel(CellTable<TagButton> tagButtonTable, TagInputPanel inputPanel, TagPreviewPanel tagPreviewPanel, TagFooterPanel footerPanel) {
        Button okButton = inputPanel.getOkButton();
        okButton.setStyleName(this.style.tagDialogButton());
        okButton.addStyleName("gwt-Button");
        Button cancelButton = inputPanel.getCancelButton();
        cancelButton.setStyleName(this.style.tagDialogButton());
        cancelButton.addStyleName("gwt-Button");
        FlowPanel controlButtonPanel = new FlowPanel();
        controlButtonPanel.setStyleName(this.style.buttonsPanel());
        controlButtonPanel.add((Widget)okButton);
        controlButtonPanel.add((Widget)cancelButton);
        return controlButtonPanel;
    }

    private void setRowData(CellTable<TagButton> tagButtonTable, List<TagButton> buttons) {
        tagButtonTable.setRowData(buttons);
        tagButtonTable.setVisible(!buttons.isEmpty());
    }

    private void onSaveTagButtonChangesPressed() {
        this.selectedTagButton.setText(this.inputPanel.getTag());
        this.selectedTagButton.setTag(this.inputPanel.getTag());
        this.selectedTagButton.setComment(this.inputPanel.getComment());
        this.selectedTagButton.setImageURL(this.inputPanel.getImageURL());
        this.selectedTagButton.setVisibleForPublic(this.inputPanel.isVisibleForPublic());
        this.footerPanel.storeAllTagButtons();
        this.inputPanel.clearAllValues();
        this.tagPreviewPanel.renderPreview(this.inputPanel);
        this.tagButtonTable.redraw();
        this.setButtonMode(false);
        this.selectedTagButton = null;
        this.setRowData(this.tagButtonTable, this.taggingComponent.getTagButtons());
        this.center();
    }

    private void onCancelTagButtonChangesPressed() {
        if (!this.inputPanel.compareFieldsToTagButton(this.selectedTagButton)) {
            ConfirmationDialog.create((String)this.stringMessages.tagDiscardChangesHeading(), (String)this.stringMessages.tagDiscardChanges(), (String)this.stringMessages.confirm(), (String)this.stringMessages.cancel(), () -> {
                this.inputPanel.clearAllValues();
                this.tagPreviewPanel.renderPreview(this.inputPanel);
                this.tagButtonTable.setVisible(true);
                this.setButtonMode(false);
                this.center();
            }).center();
        } else {
            this.inputPanel.clearAllValues();
            this.tagPreviewPanel.renderPreview(this.inputPanel);
            this.tagButtonTable.setVisible(true);
            this.setButtonMode(false);
            this.center();
        }
    }

    private void onAddTagButtonPressed() {
        if (this.inputPanel.getTag().isEmpty()) {
            Notification.notify((String)this.stringMessages.tagNotSpecified(), (Notification.NotificationType)Notification.NotificationType.WARNING);
        } else {
            TagButton tagButton = new TagButton(this.inputPanel.getTag(), this.inputPanel.getTag(), this.inputPanel.getImageURL(), this.inputPanel.getComment(), this.inputPanel.isVisibleForPublic());
            this.inputPanel.clearAllValues();
            this.tagPreviewPanel.renderPreview(this.inputPanel);
            this.taggingComponent.addTagButton(tagButton);
            this.footerPanel.storeAllTagButtons();
            this.footerPanel.recalculateHeight();
            this.setRowData(this.tagButtonTable, this.taggingComponent.getTagButtons());
        }
        this.center();
    }

    private void onCloseButtonPressed() {
        this.hide();
    }

    private void setButtonMode(boolean updateTag) {
        if (updateTag) {
            this.inputPanel.getOkButton().setText(this.stringMessages.save());
            this.inputPanel.getCancelButton().setText(this.stringMessages.cancel());
            this.updateTagMode = true;
        } else {
            this.inputPanel.getOkButton().setText(this.stringMessages.tagAddCustomTagButton());
            this.inputPanel.getCancelButton().setText(this.stringMessages.close());
            this.updateTagMode = false;
        }
    }

    static /* synthetic */ TaggingPanelResources access$0(TagButtonDialog tagButtonDialog) {
        return tagButtonDialog.resources;
    }

    static /* synthetic */ boolean access$1(TagButtonDialog tagButtonDialog) {
        return tagButtonDialog.updateTagMode;
    }

    static /* synthetic */ void access$2(TagButtonDialog tagButtonDialog) {
        tagButtonDialog.onSaveTagButtonChangesPressed();
    }

    static /* synthetic */ void access$3(TagButtonDialog tagButtonDialog) {
        tagButtonDialog.onAddTagButtonPressed();
    }

    static /* synthetic */ void access$4(TagButtonDialog tagButtonDialog) {
        tagButtonDialog.onCancelTagButtonChangesPressed();
    }

    static /* synthetic */ void access$5(TagButtonDialog tagButtonDialog) {
        tagButtonDialog.onCloseButtonPressed();
    }

    static /* synthetic */ StringMessages access$6(TagButtonDialog tagButtonDialog) {
        return tagButtonDialog.stringMessages;
    }

    static /* synthetic */ TaggingComponent access$7(TagButtonDialog tagButtonDialog) {
        return tagButtonDialog.taggingComponent;
    }

    static /* synthetic */ void access$8(TagButtonDialog tagButtonDialog, CellTable cellTable, List list) {
        tagButtonDialog.setRowData(cellTable, list);
    }

    static /* synthetic */ void access$9(TagButtonDialog tagButtonDialog, TagButton tagButton) {
        tagButtonDialog.selectedTagButton = tagButton;
    }

    static /* synthetic */ void access$10(TagButtonDialog tagButtonDialog, boolean bl) {
        tagButtonDialog.setButtonMode(bl);
    }
}

