/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.settings.client.leaderboard.AbstractLeaderboardPerspectiveLifecycle;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardPerspectiveOwnSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.DebugIdHelper;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.ViewerToolbar;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.AbstractPerspectiveComposite;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;

public abstract class AbstractLeaderboardViewer<PL extends AbstractLeaderboardPerspectiveLifecycle>
extends AbstractPerspectiveComposite<PL, LeaderboardPerspectiveOwnSettings> {
    protected static final ViewerToolbar RES = (ViewerToolbar)GWT.create(ViewerToolbar.class);
    protected final StringMessages stringMessages;
    private LeaderboardPanel<?> leaderboardPanel;
    protected final CompetitorSelectionModel competitorSelectionProvider;
    protected final AsyncActionsExecutor asyncActionsExecutor;
    private FlowPanel componentsNavigationPanel;
    protected final Timer timer;
    protected final boolean hideToolbar;

    public AbstractLeaderboardViewer(Component<?> parent, ComponentContext<PerspectiveCompositeSettings<LeaderboardPerspectiveOwnSettings>> componentContext, PL lifecycle, PerspectiveCompositeSettings<LeaderboardPerspectiveOwnSettings> settings, CompetitorSelectionModel competitorSelectionProvider, AsyncActionsExecutor asyncActionsExecutor, Timer timer, StringMessages stringMessages) {
        super(parent, componentContext, lifecycle, settings);
        this.competitorSelectionProvider = competitorSelectionProvider;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.stringMessages = stringMessages;
        this.timer = timer;
        this.hideToolbar = ((LeaderboardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings()).isHideToolbar();
        RES.css().ensureInjected();
    }

    protected void init(LeaderboardPanel<?> leaderboardPanel) {
        this.addChildComponent(leaderboardPanel);
        this.leaderboardPanel = leaderboardPanel;
    }

    public LeaderboardPanel<?> getLeaderboardPanel() {
        return this.leaderboardPanel;
    }

    protected FlowPanel createViewerPanel() {
        FlowPanel mainPanel = new FlowPanel();
        mainPanel.setSize("100%", "100%");
        mainPanel.getElement().getStyle().setMarginLeft(12.0, Style.Unit.PX);
        mainPanel.getElement().getStyle().setMarginRight(12.0, Style.Unit.PX);
        if (!this.hideToolbar) {
            this.componentsNavigationPanel = new FlowPanel();
            this.componentsNavigationPanel.addStyleName(RES.css().viewerToolbar());
            mainPanel.add((Widget)this.componentsNavigationPanel);
        }
        return mainPanel;
    }

    protected <SettingsType extends Settings> void addComponentToNavigationMenu(Component<SettingsType> component, boolean isCheckboxEnabled, String componentDisplayName, boolean hasSettingsWhenComponentIsInvisible) {
        if (!this.hideToolbar) {
            String componentName = componentDisplayName != null ? componentDisplayName : component.getLocalizedShortName();
            String debugIdPrefix = DebugIdHelper.createDebugId((String)componentName);
            CheckBox checkBox = new CheckBox(componentName);
            checkBox.ensureDebugId(String.valueOf(debugIdPrefix) + "DisplayCheckBox");
            Button settingsButton = new Button("");
            settingsButton.ensureDebugId(String.valueOf(debugIdPrefix) + "SettingsButton");
            checkBox.getElement().getStyle().setFloat(Style.Float.LEFT);
            checkBox.setEnabled(isCheckboxEnabled);
            checkBox.setValue(Boolean.valueOf(component.isVisible()));
            checkBox.setTitle(this.stringMessages.showHideComponent(componentName));
            checkBox.addStyleName(RES.css().viewerToolbarInnerElement());
            checkBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.componentsNavigationPanel.add((Widget)checkBox);
            if (component.hasSettings()) {
                settingsButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            }
            settingsButton.setEnabled(component.hasSettings() && hasSettingsWhenComponentIsInvisible);
            settingsButton.addStyleName(RES.css().viewerToolbarSettingsButton());
            settingsButton.getElement().getStyle().setFloat(Style.Float.LEFT);
            settingsButton.setTitle(this.stringMessages.settingsForComponent(componentName));
            this.componentsNavigationPanel.add((Widget)settingsButton);
        }
    }

    public SettingsDialogComponent<LeaderboardPerspectiveOwnSettings> getPerspectiveOwnSettingsDialogComponent() {
        return null;
    }

    public boolean hasPerspectiveOwnSettings() {
        return true;
    }

    public String getId() {
        return null;
    }

    public String getDependentCssClassName() {
        return null;
    }
}

